/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.collect.ImmutableSortedSet;
import com.google.gerrit.common.TimeUtil;
import com.google.gerrit.extensions.api.changes.HashtagsInput;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.webui.UiAction;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.change.SetHashtagsOp;
import com.google.gerrit.server.update.BatchUpdate;
import com.google.gerrit.server.update.UpdateException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;

@Singleton
public class PostHashtags
implements RestModifyView<ChangeResource, HashtagsInput>,
UiAction<ChangeResource> {
    private final Provider<ReviewDb> db;
    private final BatchUpdate.Factory batchUpdateFactory;
    private final SetHashtagsOp.Factory hashtagsFactory;

    @Inject
    PostHashtags(Provider<ReviewDb> db, BatchUpdate.Factory batchUpdateFactory, SetHashtagsOp.Factory hashtagsFactory) {
        this.db = db;
        this.batchUpdateFactory = batchUpdateFactory;
        this.hashtagsFactory = hashtagsFactory;
    }

    public Response<ImmutableSortedSet<String>> apply(ChangeResource req, HashtagsInput input) throws RestApiException, UpdateException {
        try (BatchUpdate bu = this.batchUpdateFactory.create(this.db.get(), req.getChange().getProject(), req.getControl().getUser(), TimeUtil.nowTs());){
            SetHashtagsOp op = this.hashtagsFactory.create(input);
            bu.addOp(req.getId(), op);
            bu.execute();
            Response<ImmutableSortedSet<String>> response = Response.ok(op.getUpdatedHashtags());
            return response;
        }
    }

    @Override
    public UiAction.Description getDescription(ChangeResource resource) {
        return new UiAction.Description().setLabel("Edit Hashtags").setVisible(resource.getControl().canEditHashtags());
    }
}

