/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.collect.ImmutableList;
import com.google.gerrit.extensions.restapi.BinaryResult;
import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.reviewdb.server.ReviewDbUtil;
import com.google.gerrit.server.CommentsUtil;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.notedb.ChangeBundle;
import com.google.gerrit.server.notedb.ChangeBundleReader;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.notedb.NotesMigration;
import com.google.gerrit.server.notedb.rebuild.ChangeRebuilder;
import com.google.gerrit.server.project.NoSuchChangeException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.stream.Collectors;
import org.eclipse.jgit.errors.ConfigInvalidException;

@Singleton
public class Rebuild
implements RestModifyView<ChangeResource, Input> {
    private final Provider<ReviewDb> db;
    private final NotesMigration migration;
    private final ChangeRebuilder rebuilder;
    private final ChangeBundleReader bundleReader;
    private final CommentsUtil commentsUtil;
    private final ChangeNotes.Factory notesFactory;

    @Inject
    Rebuild(Provider<ReviewDb> db, NotesMigration migration, ChangeRebuilder rebuilder, ChangeBundleReader bundleReader, CommentsUtil commentsUtil, ChangeNotes.Factory notesFactory) {
        this.db = db;
        this.migration = migration;
        this.rebuilder = rebuilder;
        this.bundleReader = bundleReader;
        this.commentsUtil = commentsUtil;
        this.notesFactory = notesFactory;
    }

    public BinaryResult apply(ChangeResource rsrc, Input input) throws ResourceNotFoundException, IOException, OrmException, ConfigInvalidException {
        if (!this.migration.commitChangeWrites()) {
            throw new ResourceNotFoundException();
        }
        if (!this.migration.readChanges()) {
            this.rebuild(rsrc);
            return BinaryResult.create("Rebuilt change successfully");
        }
        ChangeBundle reviewDbBundle = this.bundleReader.fromReviewDb(ReviewDbUtil.unwrapDb(this.db.get()), rsrc.getId());
        this.rebuild(rsrc);
        ChangeNotes notes = this.notesFactory.create(this.db.get(), rsrc.getChange().getProject(), rsrc.getId());
        ChangeBundle noteDbBundle = ChangeBundle.fromNotes(this.commentsUtil, notes);
        ImmutableList<String> diffs = reviewDbBundle.differencesFrom(noteDbBundle);
        if (diffs.isEmpty()) {
            return BinaryResult.create("No differences between ReviewDb and NoteDb");
        }
        return BinaryResult.create(diffs.stream().collect(Collectors.joining("\n", "Differences between ReviewDb and NoteDb:\n", "\n")));
    }

    private void rebuild(ChangeResource rsrc) throws ResourceNotFoundException, OrmException, IOException {
        try {
            this.rebuilder.rebuild(this.db.get(), rsrc.getId());
        }
        catch (NoSuchChangeException e) {
            throw new ResourceNotFoundException(IdString.fromDecoded(rsrc.getId().toString()));
        }
    }

    public static class Input {
    }
}

