/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.extensions.events;

import com.google.common.collect.Lists;
import com.google.gerrit.extensions.api.changes.NotifyHandling;
import com.google.gerrit.extensions.common.AccountInfo;
import com.google.gerrit.extensions.common.ChangeInfo;
import com.google.gerrit.extensions.common.RevisionInfo;
import com.google.gerrit.extensions.events.ReviewerAddedListener;
import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.server.GpgException;
import com.google.gerrit.server.extensions.events.AbstractRevisionEvent;
import com.google.gerrit.server.extensions.events.EventUtil;
import com.google.gerrit.server.patch.PatchListNotAvailableException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ReviewerAdded {
    private static final Logger log = LoggerFactory.getLogger(ReviewerAdded.class);
    private final DynamicSet<ReviewerAddedListener> listeners;
    private final EventUtil util;

    @Inject
    ReviewerAdded(DynamicSet<ReviewerAddedListener> listeners, EventUtil util) {
        this.listeners = listeners;
        this.util = util;
    }

    public void fire(Change change, PatchSet patchSet, List<Account> reviewers, Account adder, Timestamp when) {
        if (!this.listeners.iterator().hasNext() || reviewers.isEmpty()) {
            return;
        }
        try {
            Event event = new Event(this.util.changeInfo(change), this.util.revisionInfo(change.getProject(), patchSet), Lists.transform(reviewers, this.util::accountInfo), this.util.accountInfo(adder), when);
            for (ReviewerAddedListener l : this.listeners) {
                try {
                    l.onReviewersAdded(event);
                }
                catch (Exception e) {
                    this.util.logEventListenerError(this, l, e);
                }
            }
        }
        catch (GpgException | PatchListNotAvailableException | OrmException | IOException e) {
            log.error("Couldn't fire event", e);
        }
    }

    private static class Event
    extends AbstractRevisionEvent
    implements ReviewerAddedListener.Event {
        private final List<AccountInfo> reviewers;

        Event(ChangeInfo change, RevisionInfo revision, List<AccountInfo> reviewers, AccountInfo adder, Timestamp when) {
            super(change, revision, adder, when, NotifyHandling.ALL);
            this.reviewers = reviewers;
        }

        @Override
        public List<AccountInfo> getReviewers() {
            return this.reviewers;
        }
    }
}

