/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git;

import com.google.gerrit.server.ChangeUtil;
import com.google.gerrit.server.config.CanonicalWebUrl;
import com.google.gerrit.server.git.ChangeReportFormatter;
import com.google.inject.Inject;

public class DefaultChangeReportFormatter
implements ChangeReportFormatter {
    private final String canonicalWebUrl;

    @Inject
    DefaultChangeReportFormatter(@CanonicalWebUrl String canonicalWebUrl) {
        this.canonicalWebUrl = canonicalWebUrl;
    }

    @Override
    public String newChange(ChangeReportFormatter.Input input) {
        return this.formatChangeUrl(this.canonicalWebUrl, input);
    }

    @Override
    public String changeUpdated(ChangeReportFormatter.Input input) {
        return this.formatChangeUrl(this.canonicalWebUrl, input);
    }

    @Override
    public String changeClosed(ChangeReportFormatter.Input input) {
        return String.format("change %s closed", ChangeUtil.formatChangeUrl(this.canonicalWebUrl, input.change()));
    }

    private String formatChangeUrl(String url, ChangeReportFormatter.Input input) {
        StringBuilder m = new StringBuilder().append("  ").append(ChangeUtil.formatChangeUrl(url, input.change())).append(" ").append(ChangeUtil.cropSubject(input.subject()));
        if (input.isDraft().booleanValue()) {
            m.append(" [DRAFT]");
        }
        if (input.isEdit().booleanValue()) {
            m.append(" [EDIT]");
        }
        return m.toString();
    }
}

