/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git;

import com.google.gerrit.extensions.events.LifecycleListener;
import com.google.gerrit.server.config.SitePaths;
import com.google.gerrit.server.util.SystemLog;
import com.google.inject.Inject;
import java.nio.file.Path;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

public class GarbageCollectionLogFile
implements LifecycleListener {
    @Inject
    public GarbageCollectionLogFile(SitePaths sitePaths) {
        if (SystemLog.shouldConfigure()) {
            GarbageCollectionLogFile.initLogSystem(sitePaths.logs_dir);
        }
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        LogManager.getLogger("gc_log").removeAllAppenders();
    }

    private static void initLogSystem(Path logdir) {
        Logger gcLogger = LogManager.getLogger("gc_log");
        gcLogger.removeAllAppenders();
        gcLogger.addAppender(SystemLog.createAppender(logdir, "gc_log", new PatternLayout("[%d] %-5p %x: %m%n")));
        gcLogger.setAdditivity(false);
    }
}

