/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git;

import com.google.gerrit.server.git.CodeReviewCommit;
import com.google.gerrit.server.git.strategy.CommitMergeStatus;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevCommitList;
import org.eclipse.jgit.revwalk.RevFlag;

public class MergeSorter {
    private final CodeReviewCommit.CodeReviewRevWalk rw;
    private final RevFlag canMergeFlag;
    private final Set<RevCommit> accepted;

    public MergeSorter(CodeReviewCommit.CodeReviewRevWalk rw, Set<RevCommit> alreadyAccepted, RevFlag canMergeFlag) {
        this.rw = rw;
        this.canMergeFlag = canMergeFlag;
        this.accepted = alreadyAccepted;
    }

    Collection<CodeReviewCommit> sort(Collection<CodeReviewCommit> toMerge) throws IOException {
        return this.sort(toMerge, toMerge);
    }

    Collection<CodeReviewCommit> sort(Collection<CodeReviewCommit> toMerge, Collection<CodeReviewCommit> incoming) throws IOException {
        HashSet<CodeReviewCommit> heads = new HashSet<CodeReviewCommit>();
        HashSet<CodeReviewCommit> sort = new HashSet<CodeReviewCommit>(toMerge);
        while (!sort.isEmpty()) {
            CodeReviewCommit c;
            CodeReviewCommit n = MergeSorter.removeOne(sort);
            this.rw.resetRetain(this.canMergeFlag);
            this.rw.markStart(n);
            for (RevCommit c2 : this.accepted) {
                this.rw.markUninteresting(c2);
            }
            RevCommitList<CodeReviewCommit> contents = new RevCommitList<CodeReviewCommit>();
            while ((c = this.rw.next()) != null) {
                if (!c.has(this.canMergeFlag) || !incoming.contains(c)) {
                    n.setStatusCode(CommitMergeStatus.MISSING_DEPENDENCY);
                    break;
                }
                contents.add(c);
            }
            if (n.getStatusCode() == CommitMergeStatus.MISSING_DEPENDENCY) continue;
            sort.removeAll(contents);
            heads.removeAll(contents);
            heads.add(n);
        }
        return heads;
    }

    private static <T> T removeOne(Collection<T> c) {
        Iterator<T> i = c.iterator();
        T r = i.next();
        i.remove();
        return r;
    }
}

