/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git;

import com.google.common.collect.ImmutableSet;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.client.RefNames;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.git.SearchingChangeCacheImpl;
import com.google.gerrit.server.git.TagCache;
import com.google.gerrit.server.git.TagMatcher;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gwtorm.server.OrmException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.SymbolicRef;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.AbstractAdvertiseRefsHook;
import org.eclipse.jgit.transport.ServiceMayNotContinueException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VisibleRefFilter
extends AbstractAdvertiseRefsHook {
    private static final Logger log = LoggerFactory.getLogger(VisibleRefFilter.class);
    private final TagCache tagCache;
    private final ChangeNotes.Factory changeNotesFactory;
    @Nullable
    private final SearchingChangeCacheImpl changeCache;
    private final Repository db;
    private final Project.NameKey projectName;
    private final ProjectControl projectCtl;
    private final ReviewDb reviewDb;
    private final boolean showMetadata;
    private String userEditPrefix;
    private Set<Change.Id> visibleChanges;

    public VisibleRefFilter(TagCache tagCache, ChangeNotes.Factory changeNotesFactory, @Nullable SearchingChangeCacheImpl changeCache, Repository db, ProjectControl projectControl, ReviewDb reviewDb, boolean showMetadata) {
        this.tagCache = tagCache;
        this.changeNotesFactory = changeNotesFactory;
        this.changeCache = changeCache;
        this.db = db;
        this.projectName = projectControl.getProject().getNameKey();
        this.projectCtl = projectControl;
        this.reviewDb = reviewDb;
        this.showMetadata = showMetadata;
    }

    public Map<String, Ref> filter(Map<String, Ref> refs, boolean filterTagsSeparately) {
        boolean viewMetadata;
        Account.Id userId;
        if (this.projectCtl.getProjectState().isAllUsers()) {
            refs = this.addUsersSelfSymref(refs);
        }
        if (this.projectCtl.allRefsAreVisible(ImmutableSet.of("refs/meta/config"))) {
            return this.fastHideRefsMetaConfig(refs);
        }
        if (this.projectCtl.getUser().isIdentifiedUser()) {
            IdentifiedUser user = this.projectCtl.getUser().asIdentifiedUser();
            userId = user.getAccountId();
            viewMetadata = user.getCapabilities().canAccessDatabase();
            this.userEditPrefix = RefNames.refsEditPrefix(userId);
        } else {
            userId = null;
            viewMetadata = false;
        }
        HashMap<String, Ref> result = new HashMap<String, Ref>();
        ArrayList<Ref> deferredTags = new ArrayList<Ref>();
        for (Ref ref : refs.values()) {
            String name = ref.getName();
            if (name.startsWith("refs/cache-automerge/") || !this.showMetadata && VisibleRefFilter.isMetadata(this.projectCtl, name)) continue;
            if (RefNames.isRefsEdit(name)) {
                if (!viewMetadata && !this.visibleEdit(name)) continue;
                result.put(name, ref);
                continue;
            }
            Change.Id changeId = Change.Id.fromRef(name);
            if (changeId != null) {
                if (!viewMetadata && !this.visible(changeId)) continue;
                result.put(name, ref);
                continue;
            }
            Account.Id accountId = Account.Id.fromRef(name);
            if (accountId != null) {
                if (!viewMetadata && (!accountId.equals(userId) || !this.projectCtl.controlForRef(name).isVisible())) continue;
                result.put(name, ref);
                continue;
            }
            if (VisibleRefFilter.isTag(ref)) {
                if (ref.getObjectId() == null) continue;
                deferredTags.add(ref);
                continue;
            }
            if (name.startsWith("refs/sequences/")) {
                if (!viewMetadata) continue;
                result.put(name, ref);
                continue;
            }
            if (this.projectCtl.getProjectState().isAllUsers() && name.equals("refs/meta/external-ids")) {
                if (!viewMetadata) continue;
                result.put(name, ref);
                continue;
            }
            if (!this.projectCtl.controlForRef(ref.getLeaf().getName()).isVisible()) continue;
            result.put(name, ref);
        }
        if (!(deferredTags.isEmpty() || result.isEmpty() && !filterTagsSeparately)) {
            TagMatcher tags = this.tagCache.get(this.projectName).matcher(this.tagCache, this.db, filterTagsSeparately ? this.filter(this.db.getAllRefs()).values() : result.values());
            for (Ref tag : deferredTags) {
                if (!tags.isReachable(tag)) continue;
                result.put(tag.getName(), tag);
            }
        }
        return result;
    }

    private Map<String, Ref> fastHideRefsMetaConfig(Map<String, Ref> refs) {
        if (refs.containsKey("refs/meta/config") && !this.projectCtl.controlForRef("refs/meta/config").isVisible()) {
            HashMap<String, Ref> r = new HashMap<String, Ref>(refs);
            r.remove("refs/meta/config");
            return r;
        }
        return refs;
    }

    private Map<String, Ref> addUsersSelfSymref(Map<String, Ref> refs) {
        Ref r;
        if (this.projectCtl.getUser().isIdentifiedUser() && (r = refs.get(RefNames.refsUsers(this.projectCtl.getUser().getAccountId()))) != null) {
            SymbolicRef s = new SymbolicRef("refs/users/self", r);
            refs = new HashMap<String, Ref>(refs);
            refs.put(s.getName(), s);
        }
        return refs;
    }

    @Override
    protected Map<String, Ref> getAdvertisedRefs(Repository repository, RevWalk revWalk) throws ServiceMayNotContinueException {
        try {
            return this.filter(repository.getRefDatabase().getRefs(""));
        }
        catch (ServiceMayNotContinueException e) {
            throw e;
        }
        catch (IOException e) {
            ServiceMayNotContinueException ex = new ServiceMayNotContinueException();
            ex.initCause(e);
            throw ex;
        }
    }

    private Map<String, Ref> filter(Map<String, Ref> refs) {
        return this.filter(refs, false);
    }

    private boolean visible(Change.Id changeId) {
        if (this.visibleChanges == null) {
            this.visibleChanges = this.changeCache == null ? this.visibleChangesByScan() : this.visibleChangesBySearch();
        }
        return this.visibleChanges.contains(changeId);
    }

    private boolean visibleEdit(String name) {
        Change.Id id;
        if (this.userEditPrefix != null && name.startsWith(this.userEditPrefix) && (id = Change.Id.fromEditRefPart(name)) != null) {
            return this.visible(id);
        }
        return false;
    }

    private Set<Change.Id> visibleChangesBySearch() {
        Project project = this.projectCtl.getProject();
        try {
            HashSet<Change.Id> visibleChanges = new HashSet<Change.Id>();
            for (ChangeData cd : this.changeCache.getChangeData(this.reviewDb, project.getNameKey())) {
                if (!this.projectCtl.controlForIndexedChange(cd.change()).isVisible(this.reviewDb, cd)) continue;
                visibleChanges.add(cd.getId());
            }
            return visibleChanges;
        }
        catch (OrmException e) {
            log.error("Cannot load changes for project " + project.getName() + ", assuming no changes are visible", e);
            return Collections.emptySet();
        }
    }

    private Set<Change.Id> visibleChangesByScan() {
        Project.NameKey project = this.projectCtl.getProject().getNameKey();
        try {
            HashSet<Change.Id> visibleChanges = new HashSet<Change.Id>();
            for (ChangeNotes cn : this.changeNotesFactory.scan(this.db, this.reviewDb, project)) {
                if (!this.projectCtl.controlFor(cn).isVisible(this.reviewDb)) continue;
                visibleChanges.add(cn.getChangeId());
            }
            return visibleChanges;
        }
        catch (OrmException | IOException e) {
            log.error("Cannot load changes for project " + project + ", assuming no changes are visible", e);
            return Collections.emptySet();
        }
    }

    private static boolean isMetadata(ProjectControl projectCtl, String name) {
        return name.startsWith("refs/changes/") || RefNames.isRefsEdit(name) || projectCtl.getProjectState().isAllUsers() && name.equals("refs/meta/external-ids");
    }

    private static boolean isTag(Ref ref) {
        return ref.getLeaf().getName().startsWith("refs/tags/");
    }
}

