/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.index;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.gerrit.server.config.SitePaths;
import com.google.gerrit.server.index.GerritIndexStatus;
import com.google.gerrit.server.index.QueryOptions;
import com.google.gerrit.server.index.account.AccountField;
import com.google.gerrit.server.index.change.ChangeField;
import com.google.gerrit.server.index.group.GroupField;
import java.io.IOException;
import java.util.Set;
import org.eclipse.jgit.errors.ConfigInvalidException;

public final class IndexUtils {
    public static final ImmutableMap<String, String> CUSTOM_CHAR_MAPPING = ImmutableMap.of("_", " ", ".", " ");

    public static void setReady(SitePaths sitePaths, String name, int version, boolean ready) throws IOException {
        try {
            GerritIndexStatus cfg = new GerritIndexStatus(sitePaths);
            cfg.setReady(name, version, ready);
            cfg.save();
        }
        catch (ConfigInvalidException e) {
            throw new IOException(e);
        }
    }

    public static boolean getReady(SitePaths sitePaths, String name, int version) throws IOException {
        try {
            GerritIndexStatus cfg = new GerritIndexStatus(sitePaths);
            return cfg.getReady(name, version);
        }
        catch (ConfigInvalidException e) {
            throw new IOException(e);
        }
    }

    public static Set<String> accountFields(QueryOptions opts) {
        ImmutableSet<String> fs = opts.fields();
        return fs.contains(AccountField.ID.getName()) ? fs : Sets.union(fs, ImmutableSet.of(AccountField.ID.getName()));
    }

    public static Set<String> changeFields(QueryOptions opts) {
        ImmutableSet<String> fs = opts.fields();
        if (fs.contains(ChangeField.CHANGE.getName())) {
            return fs;
        }
        if (fs.contains(ChangeField.PROJECT.getName()) && fs.contains(ChangeField.LEGACY_ID.getName())) {
            return fs;
        }
        return Sets.union(fs, ImmutableSet.of(ChangeField.LEGACY_ID.getName(), ChangeField.PROJECT.getName()));
    }

    public static Set<String> groupFields(QueryOptions opts) {
        ImmutableSet<String> fs = opts.fields();
        return fs.contains(GroupField.UUID.getName()) ? fs : Sets.union(fs, ImmutableSet.of(GroupField.UUID.getName()));
    }

    private IndexUtils() {
    }
}

