/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.index.change;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gerrit.extensions.events.GitReferenceUpdatedListener;
import com.google.gerrit.reviewdb.client.Branch;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.git.QueueProvider;
import com.google.gerrit.server.index.IndexExecutor;
import com.google.gerrit.server.index.change.ChangeIndexCollection;
import com.google.gerrit.server.index.change.ChangeIndexer;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.project.NoSuchChangeException;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.InternalChangeQuery;
import com.google.gerrit.server.util.ManualRequestContext;
import com.google.gerrit.server.util.OneOffRequestContext;
import com.google.gerrit.server.util.RequestContext;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReindexAfterUpdate
implements GitReferenceUpdatedListener {
    private static final Logger log = LoggerFactory.getLogger(ReindexAfterUpdate.class);
    private final OneOffRequestContext requestContext;
    private final Provider<InternalChangeQuery> queryProvider;
    private final ChangeIndexer.Factory indexerFactory;
    private final ChangeIndexCollection indexes;
    private final ChangeNotes.Factory notesFactory;
    private final ListeningExecutorService executor;

    @Inject
    ReindexAfterUpdate(OneOffRequestContext requestContext, Provider<InternalChangeQuery> queryProvider, ChangeIndexer.Factory indexerFactory, ChangeIndexCollection indexes, ChangeNotes.Factory notesFactory, @IndexExecutor(value=QueueProvider.QueueType.BATCH) ListeningExecutorService executor) {
        this.requestContext = requestContext;
        this.queryProvider = queryProvider;
        this.indexerFactory = indexerFactory;
        this.indexes = indexes;
        this.notesFactory = notesFactory;
        this.executor = executor;
    }

    @Override
    public void onGitReferenceUpdated(final GitReferenceUpdatedListener.Event event) {
        if (event.getRefName().startsWith("refs/changes/") || event.getRefName().startsWith("refs/draft-comments/") || event.getRefName().startsWith("refs/users/")) {
            return;
        }
        Futures.addCallback(this.executor.submit((Callable)new GetChanges(event)), new FutureCallback<List<Change>>(){

            @Override
            public void onSuccess(List<Change> changes) {
                for (Change c : changes) {
                    Future future = ReindexAfterUpdate.this.executor.submit((Callable)new Index(event, c.getId()));
                }
            }

            @Override
            public void onFailure(Throwable ignored) {
            }
        }, MoreExecutors.directExecutor());
    }

    private class Index
    extends Task<Void> {
        private final Change.Id id;

        Index(GitReferenceUpdatedListener.Event event, Change.Id id) {
            super(event);
            this.id = id;
        }

        @Override
        protected Void impl(RequestContext ctx) throws OrmException, IOException {
            ReviewDb db = ctx.getReviewDbProvider().get();
            try {
                Change c = ReindexAfterUpdate.this.notesFactory.createChecked(db, new Project.NameKey(this.event.getProjectName()), this.id).getChange();
                ReindexAfterUpdate.this.indexerFactory.create(ReindexAfterUpdate.this.executor, ReindexAfterUpdate.this.indexes).index(db, c);
            }
            catch (NoSuchChangeException e) {
                ReindexAfterUpdate.this.indexerFactory.create(ReindexAfterUpdate.this.executor, ReindexAfterUpdate.this.indexes).delete(this.id);
            }
            return null;
        }

        public String toString() {
            return "Index change " + this.id.get() + " of project " + this.event.getProjectName();
        }
    }

    private class GetChanges
    extends Task<List<Change>> {
        private GetChanges(GitReferenceUpdatedListener.Event event) {
            super(event);
        }

        @Override
        protected List<Change> impl(RequestContext ctx) throws OrmException {
            String ref = this.event.getRefName();
            Project.NameKey project = new Project.NameKey(this.event.getProjectName());
            if (ref.equals("refs/meta/config")) {
                return ChangeData.asChanges(((InternalChangeQuery)ReindexAfterUpdate.this.queryProvider.get()).byProjectOpen(project));
            }
            return ChangeData.asChanges(((InternalChangeQuery)ReindexAfterUpdate.this.queryProvider.get()).byBranchNew(new Branch.NameKey(project, ref)));
        }

        public String toString() {
            return "Get changes to reindex caused by " + this.event.getRefName() + " update of project " + this.event.getProjectName();
        }
    }

    private abstract class Task<V>
    implements Callable<V> {
        protected GitReferenceUpdatedListener.Event event;

        protected Task(GitReferenceUpdatedListener.Event event) {
            this.event = event;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public final V call() throws Exception {
            try (ManualRequestContext ctx = ReindexAfterUpdate.this.requestContext.open();){
                V v = this.impl(ctx);
                return v;
            }
            catch (Exception e) {
                log.error("Failed to reindex changes after " + this.event, e);
                throw e;
            }
        }

        protected abstract V impl(RequestContext var1) throws Exception;
    }
}

