/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.mail.send;

import com.google.common.base.Strings;
import com.google.common.collect.Ordering;
import com.google.gerrit.common.data.FilenameComparator;
import com.google.gerrit.common.errors.EmailException;
import com.google.gerrit.common.errors.NoSuchEntityException;
import com.google.gerrit.extensions.api.changes.NotifyHandling;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.Comment;
import com.google.gerrit.reviewdb.client.Patch;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.client.RobotComment;
import com.google.gerrit.server.CommentsUtil;
import com.google.gerrit.server.account.WatchConfig;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.mail.MailUtil;
import com.google.gerrit.server.mail.receive.Protocol;
import com.google.gerrit.server.mail.send.CommentFormatter;
import com.google.gerrit.server.mail.send.EmailArguments;
import com.google.gerrit.server.mail.send.ReplyToChangeSender;
import com.google.gerrit.server.patch.PatchFile;
import com.google.gerrit.server.patch.PatchList;
import com.google.gerrit.server.patch.PatchListNotAvailableException;
import com.google.gerrit.server.util.LabelVote;
import com.google.gwtorm.client.KeyUtil;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.io.IOException;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommentSender
extends ReplyToChangeSender {
    private static final Logger log = LoggerFactory.getLogger(CommentSender.class);
    private List<Comment> inlineComments = Collections.emptyList();
    private String patchSetComment;
    private List<LabelVote> labels = Collections.emptyList();
    private final CommentsUtil commentsUtil;
    private final boolean incomingEmailEnabled;
    private final String replyToAddress;

    @Inject
    public CommentSender(EmailArguments ea, CommentsUtil commentsUtil, @GerritServerConfig Config cfg, @Assisted Project.NameKey project, @Assisted Change.Id id) throws OrmException {
        super(ea, "comment", CommentSender.newChangeData(ea, project, id));
        this.commentsUtil = commentsUtil;
        this.incomingEmailEnabled = cfg.getEnum("receiveemail", null, "protocol", Protocol.NONE).ordinal() > Protocol.NONE.ordinal();
        this.replyToAddress = cfg.getString("sendemail", null, "replyToAddress");
    }

    public void setComments(List<Comment> comments) throws OrmException {
        this.inlineComments = comments;
        HashSet<String> paths = new HashSet<String>();
        for (Comment c : comments) {
            if (Patch.isMagic(c.key.filename)) continue;
            paths.add(c.key.filename);
        }
        this.changeData.setCurrentFilePaths(Ordering.natural().sortedCopy(paths));
    }

    public void setPatchSetComment(String comment) {
        this.patchSetComment = comment;
    }

    public void setLabels(List<LabelVote> labels) {
        this.labels = labels;
    }

    @Override
    protected void init() throws EmailException {
        super.init();
        if (this.notify.compareTo(NotifyHandling.OWNER_REVIEWERS) >= 0) {
            this.ccAllApprovals();
        }
        if (this.notify.compareTo(NotifyHandling.ALL) >= 0) {
            this.bccStarredBy();
            this.includeWatchers(WatchConfig.NotifyType.ALL_COMMENTS, !this.patchSet.isDraft());
        }
        this.removeUsersThatIgnoredTheChange();
        this.setHeader("X-Gerrit-Comment-Date", this.timestamp);
        if (this.incomingEmailEnabled) {
            if (this.replyToAddress == null) {
                this.removeHeader("Reply-To");
            } else {
                this.setHeader("Reply-To", this.replyToAddress);
            }
        }
    }

    @Override
    public void formatChange() throws EmailException {
        this.appendText(this.textTemplate("Comment"));
        if (this.useHtml()) {
            this.appendHtml(this.soyHtmlTemplate("CommentHtml"));
        }
    }

    @Override
    public void formatFooter() throws EmailException {
        this.appendText(this.textTemplate("CommentFooter"));
        if (this.useHtml()) {
            this.appendHtml(this.soyHtmlTemplate("CommentFooterHtml"));
        }
    }

    @Deprecated
    public boolean hasInlineComments() {
        return !this.inlineComments.isEmpty();
    }

    @Deprecated
    public String getInlineComments() {
        return this.getInlineComments(1);
    }

    @Deprecated
    public String getInlineComments(int lines) {
        try (Repository repo = this.getRepository();){
            StringBuilder cmts = new StringBuilder();
            for (FileCommentGroup group : this.getGroupedInlineComments(repo)) {
                String link = group.getLink();
                if (link != null) {
                    cmts.append(link).append('\n');
                }
                cmts.append(group.getTitle()).append(":\n\n");
                for (Comment c : group.comments) {
                    this.appendComment(cmts, lines, group.fileData, c);
                }
                cmts.append("\n\n");
            }
            String string = cmts.toString();
            return string;
        }
    }

    private List<FileCommentGroup> getGroupedInlineComments(Repository repo) {
        ArrayList<FileCommentGroup> groups = new ArrayList<FileCommentGroup>();
        PatchList patchList = null;
        if (repo != null) {
            try {
                patchList = this.getPatchList();
            }
            catch (PatchListNotAvailableException e) {
                log.error("Failed to get patch list", e);
            }
        }
        FileCommentGroup currentGroup = null;
        for (Comment c : this.inlineComments) {
            if (currentGroup == null || !c.key.filename.equals(currentGroup.filename) || c.key.patchSetId != currentGroup.patchSetId) {
                currentGroup = new FileCommentGroup();
                currentGroup.filename = c.key.filename;
                currentGroup.patchSetId = c.key.patchSetId;
                groups.add(currentGroup);
                if (patchList != null) {
                    try {
                        currentGroup.fileData = new PatchFile(repo, patchList, c.key.filename);
                    }
                    catch (IOException e) {
                        log.warn("Cannot load {} from {} in {}", c.key.filename, patchList.getNewId().name(), this.projectState.getProject().getName(), e);
                        currentGroup.fileData = null;
                    }
                }
            }
            if (currentGroup.fileData == null) continue;
            currentGroup.comments.add(c);
        }
        Collections.sort(groups, Comparator.comparing(g -> g.filename, FilenameComparator.INSTANCE));
        return groups;
    }

    @Deprecated
    private void appendComment(StringBuilder out, int contextLines, PatchFile currentFileData, Comment comment) {
        if (comment instanceof RobotComment) {
            RobotComment robotComment = (RobotComment)comment;
            out.append("Robot Comment from ").append(robotComment.robotId).append(" (run ID ").append(robotComment.robotRunId).append("):\n");
        }
        if (comment.range != null) {
            this.appendRangedComment(out, currentFileData, comment);
        } else {
            this.appendLineComment(out, contextLines, currentFileData, comment);
        }
    }

    @Deprecated
    private void appendRangedComment(StringBuilder out, PatchFile fileData, Comment comment) {
        String prefix = this.getCommentLinePrefix(comment);
        String emptyPrefix = Strings.padStart(": ", prefix.length(), ' ');
        boolean firstLine = true;
        for (String line : this.getLinesByRange(comment.range, fileData, comment.side)) {
            out.append(firstLine ? prefix : emptyPrefix).append(line).append('\n');
            firstLine = false;
        }
        this.appendQuotedParent(out, comment);
        out.append(comment.message.trim()).append('\n');
    }

    private String getCommentLinePrefix(Comment comment) {
        int lineNbr = comment.range == null ? comment.lineNbr : comment.range.startLine;
        StringBuilder sb = new StringBuilder();
        sb.append("PS").append(comment.key.patchSetId);
        if (lineNbr != 0) {
            sb.append(", Line ").append(lineNbr);
        }
        sb.append(": ");
        return sb.toString();
    }

    private List<String> getLinesByRange(Comment.Range range, PatchFile fileData, short side) {
        ArrayList<String> lines = new ArrayList<String>();
        for (int n = range.startLine; n <= range.endLine; ++n) {
            String s = this.getLine(fileData, side, n);
            if (n == range.startLine && n == range.endLine && range.startChar < range.endChar) {
                s = s.substring(Math.min(range.startChar, s.length()), Math.min(range.endChar, s.length()));
            } else if (n == range.startLine) {
                s = s.substring(Math.min(range.startChar, s.length()));
            } else if (n == range.endLine) {
                s = s.substring(0, Math.min(range.endChar, s.length()));
            }
            lines.add(s);
        }
        return lines;
    }

    @Deprecated
    private void appendLineComment(StringBuilder out, int contextLines, PatchFile currentFileData, Comment comment) {
        int line;
        int lineNbr;
        short side = comment.side;
        int maxLines = lineNbr = comment.lineNbr;
        try {
            maxLines = currentFileData.getLineCount(side);
        }
        catch (IOException err) {
            log.warn("Failed to read file {} on side {}", comment.key.filename, side, err);
        }
        catch (NoSuchEntityException err) {
            log.warn("Side {} of file {} didn't exist", side, comment.key.filename, err);
        }
        int startLine = Math.max(1, lineNbr - contextLines + 1);
        int stopLine = Math.min(maxLines, lineNbr + contextLines);
        for (line = startLine; line <= lineNbr; ++line) {
            this.appendFileLine(out, currentFileData, side, line);
        }
        this.appendQuotedParent(out, comment);
        out.append(comment.message.trim()).append('\n');
        for (line = lineNbr + 1; line < stopLine; ++line) {
            this.appendFileLine(out, currentFileData, side, line);
        }
    }

    @Deprecated
    private void appendFileLine(StringBuilder cmts, PatchFile fileData, short side, int line) {
        String lineStr = this.getLine(fileData, side, line);
        cmts.append("Line ").append(line).append(": ").append(lineStr).append("\n");
    }

    @Deprecated
    private void appendQuotedParent(StringBuilder out, Comment child) {
        Optional<Comment> parent = this.getParent(child);
        if (parent.isPresent()) {
            out.append("> ").append(this.getShortenedCommentMessage(parent.get())).append('\n');
        }
    }

    private Optional<Comment> getParent(Comment child) {
        if (child.parentUuid == null) {
            return Optional.empty();
        }
        Comment.Key key = new Comment.Key(child.parentUuid, child.key.filename, child.key.patchSetId);
        try {
            return this.commentsUtil.get(this.args.db.get(), this.changeData.notes(), key);
        }
        catch (OrmException e) {
            log.warn("Could not find the parent of this comment: {}", (Object)child.toString());
            return Optional.empty();
        }
    }

    private List<String> getLinesOfComment(Comment comment, PatchFile fileData) {
        ArrayList<String> lines = new ArrayList<String>();
        if (comment.lineNbr == 0) {
            return lines;
        }
        if (comment.range == null) {
            lines.add(this.getLine(fileData, comment.side, comment.lineNbr));
        } else {
            lines.addAll(this.getLinesByRange(comment.range, fileData, comment.side));
        }
        return lines;
    }

    private String getShortenedCommentMessage(Comment comment) {
        int lf;
        String msg = comment.message.trim();
        if (msg.length() > 75) {
            msg = msg.substring(0, 75);
        }
        if ((lf = msg.indexOf(10)) > 0) {
            msg = msg.substring(0, lf);
        }
        return msg;
    }

    private List<Map<String, Object>> getCommentGroupsTemplateData(Repository repo) {
        ArrayList<Map<String, Object>> commentGroups = new ArrayList<Map<String, Object>>();
        for (FileCommentGroup group : this.getGroupedInlineComments(repo)) {
            HashMap<String, Object> groupData = new HashMap<String, Object>();
            groupData.put("link", group.getLink());
            groupData.put("title", group.getTitle());
            groupData.put("patchSetId", group.patchSetId);
            ArrayList commentsList = new ArrayList();
            for (Comment comment : group.comments) {
                Optional<Comment> parent;
                int startLine;
                HashMap<String, Object> commentData = new HashMap<String, Object>();
                commentData.put("lines", this.getLinesOfComment(comment, group.fileData));
                commentData.put("message", comment.message.trim());
                List<CommentFormatter.Block> blocks = CommentFormatter.parse(comment.message);
                commentData.put("messageBlocks", this.commentBlocksToSoyData(blocks));
                String prefix = this.getCommentLinePrefix(comment);
                commentData.put("linePrefix", prefix);
                commentData.put("linePrefixEmpty", Strings.padStart(": ", prefix.length(), ' '));
                if (comment.range == null) {
                    startLine = comment.lineNbr;
                } else {
                    startLine = comment.range.startLine;
                    commentData.put("endLine", comment.range.endLine);
                }
                commentData.put("startLine", startLine);
                if (comment.lineNbr == 0) {
                    commentData.put("link", group.getLink());
                } else if (comment.side == 0) {
                    commentData.put("link", group.getLink() + "@a" + startLine);
                } else {
                    commentData.put("link", group.getLink() + '@' + startLine);
                }
                if (comment instanceof RobotComment) {
                    RobotComment robotComment = (RobotComment)comment;
                    commentData.put("isRobotComment", true);
                    commentData.put("robotId", robotComment.robotId);
                    commentData.put("robotRunId", robotComment.robotRunId);
                    commentData.put("robotUrl", robotComment.url);
                } else {
                    commentData.put("isRobotComment", false);
                }
                if (!this.hasQuote(blocks) && (parent = this.getParent(comment)).isPresent()) {
                    commentData.put("parentMessage", this.getShortenedCommentMessage(parent.get()));
                }
                commentsList.add(commentData);
            }
            groupData.put("comments", commentsList);
            commentGroups.add(groupData);
        }
        return commentGroups;
    }

    private List<Map<String, Object>> commentBlocksToSoyData(List<CommentFormatter.Block> blocks) {
        return blocks.stream().map(b -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            switch (b.type) {
                case PARAGRAPH: {
                    map.put("type", "paragraph");
                    map.put("text", b.text);
                    break;
                }
                case PRE_FORMATTED: {
                    map.put("type", "pre");
                    map.put("text", b.text);
                    break;
                }
                case QUOTE: {
                    map.put("type", "quote");
                    map.put("quotedBlocks", this.commentBlocksToSoyData(b.quotedBlocks));
                    break;
                }
                case LIST: {
                    map.put("type", "list");
                    map.put("items", b.items);
                }
            }
            return map;
        }).collect(Collectors.toList());
    }

    private boolean hasQuote(List<CommentFormatter.Block> blocks) {
        for (CommentFormatter.Block block : blocks) {
            if (block.type != CommentFormatter.BlockType.QUOTE) continue;
            return true;
        }
        return false;
    }

    private Repository getRepository() {
        try {
            return this.args.server.openRepository(this.projectState.getProject().getNameKey());
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    protected void setupSoyContext() {
        super.setupSoyContext();
        boolean hasComments = false;
        try (Repository repo = this.getRepository();){
            List<Map<String, Object>> files = this.getCommentGroupsTemplateData(repo);
            this.soyContext.put("commentFiles", files);
            hasComments = !files.isEmpty();
        }
        this.soyContext.put("patchSetCommentBlocks", this.commentBlocksToSoyData(CommentFormatter.parse(this.patchSetComment)));
        this.soyContext.put("labels", this.getLabelVoteSoyData(this.labels));
        this.soyContext.put("commentCount", this.inlineComments.size());
        this.soyContext.put("commentTimestamp", this.getCommentTimestamp());
        this.soyContext.put("coverLetterBlocks", this.commentBlocksToSoyData(CommentFormatter.parse(this.getCoverLetter())));
        this.footers.add("Gerrit-Comment-Date: " + this.getCommentTimestamp());
        this.footers.add("Gerrit-HasComments: " + (hasComments ? "Yes" : "No"));
    }

    private String getLine(PatchFile fileInfo, short side, int lineNbr) {
        try {
            return fileInfo.getLine(side, lineNbr);
        }
        catch (IOException err) {
            log.warn("Failed to read file on side {}", (Object)side, (Object)err);
            return "";
        }
        catch (IndexOutOfBoundsException err) {
            log.debug("Failed to get line number of file on side {}", (Object)side, (Object)err);
            return "";
        }
        catch (NoSuchEntityException err) {
            log.warn("Side {} of file didn't exist", (Object)side, (Object)err);
            return "";
        }
    }

    private List<Map<String, Object>> getLabelVoteSoyData(List<LabelVote> votes) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (LabelVote vote : votes) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("label", vote.label());
            data.put("value", Integer.valueOf(vote.value()));
            result.add(data);
        }
        return result;
    }

    private String getCommentTimestamp() {
        return MailUtil.rfcDateformatter.format(ZonedDateTime.ofInstant(this.timestamp.toInstant(), ZoneId.of("UTC")));
    }

    @Override
    protected boolean supportsHtml() {
        return true;
    }

    private class FileCommentGroup {
        public String filename;
        public int patchSetId;
        public PatchFile fileData;
        public List<Comment> comments = new ArrayList<Comment>();

        private FileCommentGroup() {
        }

        public String getLink() {
            String url = CommentSender.this.getGerritUrl();
            if (url == null) {
                return null;
            }
            return url + "#/c/" + CommentSender.this.change.getId() + '/' + this.patchSetId + '/' + KeyUtil.encode(this.filename);
        }

        public String getTitle() {
            if ("/COMMIT_MSG".equals(this.filename)) {
                return "Commit Message";
            }
            if ("/MERGE_LIST".equals(this.filename)) {
                return "Merge List";
            }
            return "File " + this.filename;
        }
    }

    public static interface Factory {
        public CommentSender create(Project.NameKey var1, Change.Id var2);
    }
}

