/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.notedb.rebuild;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.ChangeMessage;
import com.google.gerrit.server.notedb.ChangeUpdate;
import com.google.gerrit.server.notedb.rebuild.Event;
import com.google.gwtorm.server.OrmException;
import java.sql.Timestamp;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class ChangeMessageEvent
extends Event {
    private static final ImmutableMap<Change.Status, Pattern> STATUS_PATTERNS = ImmutableMap.of(Change.Status.ABANDONED, Pattern.compile("^Abandoned(\n.*)*$"), Change.Status.MERGED, Pattern.compile("^Change has been successfully (merged|cherry-picked|rebased|pushed).*$"), Change.Status.NEW, Pattern.compile("^Restored(\n.*)*$"));
    private static final Pattern TOPIC_SET_REGEXP = Pattern.compile("^Topic set to (.+)$");
    private static final Pattern TOPIC_CHANGED_REGEXP = Pattern.compile("^Topic changed from (.+) to (.+)$");
    private static final Pattern TOPIC_REMOVED_REGEXP = Pattern.compile("^Topic (.+) removed$");
    private final Change change;
    private final Change noteDbChange;
    private final Optional<Change.Status> status;
    private final ChangeMessage message;

    ChangeMessageEvent(Change change, Change noteDbChange, ChangeMessage message, Timestamp changeCreatedOn) {
        super(message.getPatchSetId(), message.getAuthor(), message.getRealAuthor(), message.getWrittenOn(), changeCreatedOn, message.getTag());
        this.change = change;
        this.noteDbChange = noteDbChange;
        this.message = message;
        this.status = ChangeMessageEvent.parseStatus(message);
    }

    @Override
    boolean uniquePerUpdate() {
        return true;
    }

    @Override
    protected boolean isSubmit() {
        return this.status.isPresent() && this.status.get() == Change.Status.MERGED;
    }

    @Override
    protected boolean canHaveTag() {
        return true;
    }

    @Override
    void apply(ChangeUpdate update) throws OrmException {
        this.checkUpdate(update);
        update.setChangeMessage(this.message.getMessage());
        this.setTopic(update);
        if (this.status.isPresent()) {
            Change.Status s = this.status.get();
            update.fixStatus(s);
            this.noteDbChange.setStatus(s);
            if (s == Change.Status.MERGED) {
                update.setSubmissionId(this.change.getSubmissionId());
                this.noteDbChange.setSubmissionId(this.change.getSubmissionId());
            }
        }
    }

    private static Optional<Change.Status> parseStatus(ChangeMessage message) {
        String msg = message.getMessage();
        if (msg == null) {
            return Optional.empty();
        }
        for (Map.Entry e : STATUS_PATTERNS.entrySet()) {
            if (!((Pattern)e.getValue()).matcher(msg).matches()) continue;
            return Optional.of((Change.Status)((Object)e.getKey()));
        }
        return Optional.empty();
    }

    private void setTopic(ChangeUpdate update) {
        String msg = this.message.getMessage();
        if (msg == null) {
            return;
        }
        Matcher m = TOPIC_SET_REGEXP.matcher(msg);
        if (m.matches()) {
            String topic = m.group(1);
            update.setTopic(topic);
            this.noteDbChange.setTopic(topic);
            return;
        }
        m = TOPIC_CHANGED_REGEXP.matcher(msg);
        if (m.matches()) {
            String topic = m.group(2);
            update.setTopic(topic);
            this.noteDbChange.setTopic(topic);
            return;
        }
        if (TOPIC_REMOVED_REGEXP.matcher(msg).matches()) {
            update.setTopic(null);
            this.noteDbChange.setTopic(null);
        }
    }

    @Override
    protected void addToString(MoreObjects.ToStringHelper helper) {
        helper.add("message", this.message);
    }
}

