/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.gerrit.extensions.api.projects.DeleteBranchesInput;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.server.project.DeleteRef;
import com.google.gerrit.server.project.ProjectResource;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;

@Singleton
public class DeleteBranches
implements RestModifyView<ProjectResource, DeleteBranchesInput> {
    private final DeleteRef.Factory deleteRefFactory;

    @Inject
    DeleteBranches(DeleteRef.Factory deleteRefFactory) {
        this.deleteRefFactory = deleteRefFactory;
    }

    public Response<?> apply(ProjectResource project, DeleteBranchesInput input) throws OrmException, IOException, RestApiException {
        if (input == null || input.branches == null || input.branches.isEmpty()) {
            throw new BadRequestException("branches must be specified");
        }
        this.deleteRefFactory.create(project).refs(input.branches).prefix("refs/heads/").delete();
        return Response.none();
    }
}

