/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.common.collect.Maps;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.common.data.AccessSection;
import com.google.gerrit.common.data.Capable;
import com.google.gerrit.common.data.ContributorAgreement;
import com.google.gerrit.common.data.GroupReference;
import com.google.gerrit.common.data.LabelTypes;
import com.google.gerrit.common.data.Permission;
import com.google.gerrit.common.data.PermissionRule;
import com.google.gerrit.metrics.Counter0;
import com.google.gerrit.metrics.Description;
import com.google.gerrit.metrics.MetricMaker;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.client.Branch;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.GroupMembership;
import com.google.gerrit.server.change.IncludedInResolver;
import com.google.gerrit.server.config.CanonicalWebUrl;
import com.google.gerrit.server.config.GitReceivePackGroups;
import com.google.gerrit.server.config.GitUploadPackGroups;
import com.google.gerrit.server.git.SearchingChangeCacheImpl;
import com.google.gerrit.server.git.TagCache;
import com.google.gerrit.server.git.VisibleRefFilter;
import com.google.gerrit.server.group.SystemGroupBackend;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gerrit.server.project.NoSuchProjectException;
import com.google.gerrit.server.project.PerRequestProjectControlCache;
import com.google.gerrit.server.project.PermissionCollection;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.project.ProjectState;
import com.google.gerrit.server.project.RefControl;
import com.google.gerrit.server.project.SectionMatcher;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.InternalChangeQuery;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.assistedinject.Assisted;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectControl {
    public static final int VISIBLE = 1;
    public static final int OWNER = 2;
    private static final Logger log = LoggerFactory.getLogger(ProjectControl.class);
    private final Set<AccountGroup.UUID> uploadGroups;
    private final Set<AccountGroup.UUID> receiveGroups;
    private final String canonicalWebUrl;
    private final CurrentUser user;
    private final ProjectState state;
    private final ChangeNotes.Factory changeNotesFactory;
    private final ChangeControl.Factory changeControlFactory;
    private final PermissionCollection.Factory permissionFilter;
    private final Collection<ContributorAgreement> contributorAgreements;
    private final TagCache tagCache;
    @Nullable
    private final SearchingChangeCacheImpl changeCache;
    private final Provider<InternalChangeQuery> queryProvider;
    private final Metrics metrics;
    private List<SectionMatcher> allSections;
    private List<SectionMatcher> localSections;
    private LabelTypes labelTypes;
    private Map<String, RefControl> refControls;
    private Boolean declaredOwner;

    @Inject
    ProjectControl(@GitUploadPackGroups Set<AccountGroup.UUID> uploadGroups, @GitReceivePackGroups Set<AccountGroup.UUID> receiveGroups, ProjectCache pc, PermissionCollection.Factory permissionFilter, ChangeNotes.Factory changeNotesFactory, ChangeControl.Factory changeControlFactory, TagCache tagCache, Provider<InternalChangeQuery> queryProvider, @Nullable SearchingChangeCacheImpl changeCache, @CanonicalWebUrl @Nullable String canonicalWebUrl, @Assisted CurrentUser who, @Assisted ProjectState ps, Metrics metrics) {
        this.changeNotesFactory = changeNotesFactory;
        this.changeControlFactory = changeControlFactory;
        this.tagCache = tagCache;
        this.changeCache = changeCache;
        this.uploadGroups = uploadGroups;
        this.receiveGroups = receiveGroups;
        this.permissionFilter = permissionFilter;
        this.contributorAgreements = pc.getAllProjects().getConfig().getContributorAgreements();
        this.canonicalWebUrl = canonicalWebUrl;
        this.queryProvider = queryProvider;
        this.metrics = metrics;
        this.user = who;
        this.state = ps;
    }

    public ProjectControl forUser(CurrentUser who) {
        ProjectControl r = this.state.controlFor(who);
        r.allSections = this.allSections;
        return r;
    }

    public ChangeControl controlFor(ReviewDb db, Change change) throws OrmException {
        return this.changeControlFactory.create(this.controlForRef(change.getDest()), db, change.getProject(), change.getId());
    }

    public ChangeControl controlForIndexedChange(Change change) {
        return this.changeControlFactory.createForIndexedChange(this.controlForRef(change.getDest()), change);
    }

    public ChangeControl controlFor(ChangeNotes notes) {
        return this.changeControlFactory.create(this.controlForRef(notes.getChange().getDest()), notes);
    }

    public RefControl controlForRef(Branch.NameKey ref) {
        return this.controlForRef(ref.get());
    }

    public RefControl controlForRef(String refName) {
        RefControl ctl;
        if (this.refControls == null) {
            this.refControls = new HashMap<String, RefControl>();
        }
        if ((ctl = this.refControls.get(refName)) == null) {
            PermissionCollection relevant = this.permissionFilter.filter(this.access(), refName, this.user);
            ctl = new RefControl(this, refName, relevant);
            this.refControls.put(refName, ctl);
        }
        return ctl;
    }

    public CurrentUser getUser() {
        return this.user;
    }

    public ProjectState getProjectState() {
        return this.state;
    }

    public Project getProject() {
        return this.state.getProject();
    }

    public LabelTypes getLabelTypes() {
        if (this.labelTypes == null) {
            this.labelTypes = this.state.getLabelTypes();
        }
        return this.labelTypes;
    }

    public boolean isHidden() {
        return this.getProject().getState().equals((Object)com.google.gerrit.extensions.client.ProjectState.HIDDEN);
    }

    public boolean isReadable() {
        return this.user.isInternalUser() || this.canPerformOnAnyRef("read");
    }

    public boolean isVisible() {
        return this.isReadable() && !this.isHidden();
    }

    public boolean canAddRefs() {
        return this.canPerformOnAnyRef("create") || this.isOwnerAnyRef();
    }

    public boolean canAddTagRefs() {
        return this.canPerformOnTagRef("create") || this.isOwnerAnyRef();
    }

    public boolean canUpload() {
        for (SectionMatcher matcher : this.access()) {
            Permission permission;
            AccessSection section = matcher.section;
            if (!section.getName().startsWith("refs/for/") || (permission = section.getPermission("push")) == null || !this.controlForRef(section.getName()).canPerform("push")) continue;
            return true;
        }
        return false;
    }

    public boolean allRefsAreVisible() {
        return this.allRefsAreVisible(Collections.emptySet());
    }

    public boolean allRefsAreVisible(Set<String> ignore) {
        return this.user.isInternalUser() || this.canPerformOnAllRefs("read", ignore);
    }

    public boolean isOwner() {
        return this.isDeclaredOwner() && !this.controlForRef("refs/*").isBlocked("owner") || this.user.getCapabilities().canAdministrateServer();
    }

    private boolean isDeclaredOwner() {
        if (this.declaredOwner == null) {
            GroupMembership effectiveGroups = this.user.getEffectiveGroups();
            this.declaredOwner = effectiveGroups.containsAnyOf(this.state.getAllOwners());
        }
        return this.declaredOwner;
    }

    public boolean isOwnerAnyRef() {
        return this.canPerformOnAnyRef("owner") || this.user.getCapabilities().canAdministrateServer();
    }

    public Capable canPushToAtLeastOneRef() {
        if (!(this.canPerformOnAnyRef("push") || this.canPerformOnAnyRef("createTag") || this.isOwner())) {
            String pName = this.state.getProject().getName();
            return new Capable("Upload denied for project '" + pName + "'");
        }
        if (this.state.isUseContributorAgreements()) {
            return this.verifyActiveContributorAgreement();
        }
        return Capable.OK;
    }

    public Set<GroupReference> getAllGroups() {
        return ProjectControl.getGroups(this.access());
    }

    public Set<GroupReference> getLocalGroups() {
        return ProjectControl.getGroups(this.localAccess());
    }

    private static Set<GroupReference> getGroups(List<SectionMatcher> sectionMatcherList) {
        HashSet<GroupReference> all = new HashSet<GroupReference>();
        for (SectionMatcher matcher : sectionMatcherList) {
            AccessSection section = matcher.section;
            for (Permission permission : section.getPermissions()) {
                for (PermissionRule rule : permission.getRules()) {
                    all.add(rule.getGroup());
                }
            }
        }
        return all;
    }

    private Capable verifyActiveContributorAgreement() {
        this.metrics.claCheckCount.increment();
        if (!this.user.isIdentifiedUser()) {
            return new Capable("Must be logged in to verify Contributor Agreement");
        }
        IdentifiedUser iUser = this.user.asIdentifiedUser();
        ArrayList<AccountGroup.UUID> okGroupIds = new ArrayList<AccountGroup.UUID>();
        for (ContributorAgreement ca : this.contributorAgreements) {
            ArrayList<AccountGroup.UUID> groupIds = okGroupIds;
            for (PermissionRule rule : ca.getAccepted()) {
                if (rule.getAction() != PermissionRule.Action.ALLOW || rule.getGroup() == null || rule.getGroup().getUUID() == null) continue;
                groupIds.add(new AccountGroup.UUID(rule.getGroup().getUUID().get()));
            }
        }
        if (iUser.getEffectiveGroups().containsAnyOf(okGroupIds)) {
            return Capable.OK;
        }
        StringBuilder msg = new StringBuilder();
        msg.append("A Contributor Agreement must be completed before uploading");
        if (this.canonicalWebUrl != null) {
            msg.append(":\n\n  ");
            msg.append(this.canonicalWebUrl);
            msg.append("#");
            msg.append("/settings/agreements");
            msg.append("\n");
        } else {
            msg.append(".");
        }
        msg.append("\n");
        return new Capable(msg.toString());
    }

    private boolean canPerformOnTagRef(String permissionName) {
        for (SectionMatcher matcher : this.access()) {
            Boolean can;
            Permission permission;
            AccessSection section = matcher.section;
            if (!section.getName().startsWith("refs/tags/") || (permission = section.getPermission(permissionName)) == null || (can = this.canPerform(permissionName, section, permission)) == null) continue;
            return can;
        }
        return false;
    }

    private boolean canPerformOnAnyRef(String permissionName) {
        for (SectionMatcher matcher : this.access()) {
            Boolean can;
            AccessSection section = matcher.section;
            Permission permission = section.getPermission(permissionName);
            if (permission == null || (can = this.canPerform(permissionName, section, permission)) == null) continue;
            return can;
        }
        return false;
    }

    private Boolean canPerform(String permissionName, AccessSection section, Permission permission) {
        for (PermissionRule rule : permission.getRules()) {
            if (rule.isBlock() || rule.isDeny() || !this.match(rule)) continue;
            if (!this.controlForRef(section.getName()).canPerform(permissionName)) break;
            return true;
        }
        return null;
    }

    private boolean canPerformOnAllRefs(String permission, Set<String> ignore) {
        boolean canPerform = false;
        Set<String> patterns = this.allRefPatterns(permission);
        if (patterns.contains("refs/*")) {
            for (String pattern : patterns) {
                if (this.controlForRef(pattern).canPerform(permission)) {
                    canPerform = true;
                    continue;
                }
                if (ignore.contains(pattern)) continue;
                return false;
            }
        }
        return canPerform;
    }

    private Set<String> allRefPatterns(String permissionName) {
        HashSet<String> all = new HashSet<String>();
        for (SectionMatcher matcher : this.access()) {
            AccessSection section = matcher.section;
            Permission permission = section.getPermission(permissionName);
            if (permission == null) continue;
            all.add(section.getName());
        }
        return all;
    }

    private List<SectionMatcher> access() {
        if (this.allSections == null) {
            this.allSections = this.state.getAllSections();
        }
        return this.allSections;
    }

    private List<SectionMatcher> localAccess() {
        if (this.localSections == null) {
            this.localSections = this.state.getLocalAccessSections();
        }
        return this.localSections;
    }

    boolean match(PermissionRule rule) {
        return this.match(rule.getGroup().getUUID());
    }

    boolean match(PermissionRule rule, boolean isChangeOwner) {
        return this.match(rule.getGroup().getUUID(), isChangeOwner);
    }

    boolean match(AccountGroup.UUID uuid) {
        return this.match(uuid, false);
    }

    boolean match(AccountGroup.UUID uuid, boolean isChangeOwner) {
        if (SystemGroupBackend.PROJECT_OWNERS.equals(uuid)) {
            return this.isDeclaredOwner();
        }
        if (SystemGroupBackend.CHANGE_OWNER.equals(uuid)) {
            return isChangeOwner;
        }
        return this.user.getEffectiveGroups().contains(uuid);
    }

    public boolean canRunUploadPack() {
        for (AccountGroup.UUID group : this.uploadGroups) {
            if (!this.match(group)) continue;
            return true;
        }
        return false;
    }

    public boolean canRunReceivePack() {
        for (AccountGroup.UUID group : this.receiveGroups) {
            if (!this.match(group)) continue;
            return true;
        }
        return false;
    }

    public boolean canReadCommit(ReviewDb db, Repository repo, RevCommit commit) {
        try {
            List<ChangeData> changes = this.queryProvider.get().byProjectCommit(this.getProject().getNameKey(), commit);
            for (ChangeData change : changes) {
                if (!this.controlFor(db, change.change()).isVisible(db)) continue;
                return true;
            }
        }
        catch (OrmException e) {
            log.error("Cannot look up change for commit " + commit.name() + " in " + this.getProject().getName(), e);
        }
        return this.canReadCommitFromVisibleRef(db, repo, commit);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean canReadCommitFromVisibleRef(ReviewDb db, Repository repo, RevCommit commit) {
        try (RevWalk rw = new RevWalk(repo);){
            boolean throwable3 = this.isMergedIntoVisibleRef(repo, db, rw, commit, repo.getAllRefs().values());
            return throwable3;
        }
        catch (IOException e) {
            String msg = String.format("Cannot verify permissions to commit object %s in repository %s", commit.name(), this.getProject().getNameKey());
            log.error(msg, e);
            return false;
        }
    }

    boolean isMergedIntoVisibleRef(Repository repo, ReviewDb db, RevWalk rw, RevCommit commit, Collection<Ref> unfilteredRefs) throws IOException {
        VisibleRefFilter filter = new VisibleRefFilter(this.tagCache, this.changeNotesFactory, this.changeCache, repo, this, db, true);
        HashMap<String, Ref> m = Maps.newHashMapWithExpectedSize(unfilteredRefs.size());
        for (Ref r : unfilteredRefs) {
            m.put(r.getName(), r);
        }
        Map<String, Ref> refs = filter.filter(m, true);
        return !refs.isEmpty() && IncludedInResolver.includedInOne(repo, rw, commit, refs.values());
    }

    @Singleton
    protected static class Metrics {
        final Counter0 claCheckCount;

        @Inject
        Metrics(MetricMaker metricMaker) {
            this.claCheckCount = metricMaker.newCounter("license/cla_check_count", new Description("Total number of CLA check requests").setRate().setUnit("requests"));
        }
    }

    public static interface AssistedFactory {
        public ProjectControl create(CurrentUser var1, ProjectState var2);
    }

    public static class Factory {
        private final Provider<PerRequestProjectControlCache> userCache;

        @Inject
        Factory(Provider<PerRequestProjectControlCache> uc) {
            this.userCache = uc;
        }

        public ProjectControl controlFor(Project.NameKey nameKey) throws NoSuchProjectException {
            return this.userCache.get().get(nameKey);
        }

        public ProjectControl validateFor(Project.NameKey nameKey) throws NoSuchProjectException {
            return this.validateFor(nameKey, 1);
        }

        public ProjectControl ownerFor(Project.NameKey nameKey) throws NoSuchProjectException {
            return this.validateFor(nameKey, 2);
        }

        public ProjectControl validateFor(Project.NameKey nameKey, int need) throws NoSuchProjectException {
            ProjectControl c = this.controlFor(nameKey);
            if ((need & 1) == 1 && c.isVisible()) {
                return c;
            }
            if ((need & 2) == 2 && c.isOwner()) {
                return c;
            }
            throw new NoSuchProjectException(nameKey);
        }
    }

    public static class GenericFactory {
        private final ProjectCache projectCache;

        @Inject
        GenericFactory(ProjectCache pc) {
            this.projectCache = pc;
        }

        public ProjectControl controlFor(Project.NameKey nameKey, CurrentUser user) throws NoSuchProjectException, IOException {
            ProjectState p = this.projectCache.checkedGet(nameKey);
            if (p == null) {
                throw new NoSuchProjectException(nameKey);
            }
            return p.controlFor(user);
        }

        public ProjectControl validateFor(Project.NameKey nameKey, int need, CurrentUser user) throws NoSuchProjectException, IOException {
            ProjectControl c = this.controlFor(nameKey, user);
            if ((need & 1) == 1 && c.isVisible()) {
                return c;
            }
            if ((need & 2) == 2 && c.isOwner()) {
                return c;
            }
            throw new NoSuchProjectException(nameKey);
        }
    }
}

