/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.gerrit.common.data.ParameterizedString;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.RefNames;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.project.RefPattern;
import dk.brics.automaton.Automaton;
import java.util.HashMap;
import java.util.Set;
import java.util.regex.Pattern;

public abstract class RefPatternMatcher {
    public static RefPatternMatcher getMatcher(String pattern) {
        if (pattern.contains("${")) {
            return new ExpandParameters(pattern);
        }
        if (RefPattern.isRE(pattern)) {
            return new Regexp(pattern);
        }
        if (pattern.endsWith("/*")) {
            return new Prefix(pattern.substring(0, pattern.length() - 1));
        }
        return new Exact(pattern);
    }

    public abstract boolean match(String var1, CurrentUser var2);

    static class ExpandParameters
    extends RefPatternMatcher {
        private final ParameterizedString template;
        private final String prefix;

        ExpandParameters(String pattern) {
            this.template = new ParameterizedString(pattern);
            if (RefPattern.isRE(pattern)) {
                String replacement = ":PLACEHOLDER:";
                ImmutableMap<String, String> params = ImmutableMap.of("shardeduserid", replacement, "username", replacement);
                Automaton am = RefPattern.toRegExp(this.template.replace(params)).toAutomaton();
                String rePrefix = am.getCommonPrefix();
                this.prefix = rePrefix.substring(0, rePrefix.indexOf(replacement));
            } else {
                this.prefix = pattern.substring(0, pattern.indexOf("${"));
            }
        }

        @Override
        public boolean match(String ref, CurrentUser user) {
            if (!ref.startsWith(this.prefix)) {
                return false;
            }
            for (String username : this.getUsernames(user)) {
                Account.Id accountId;
                String u = RefPattern.isRE(this.template.getPattern()) ? Pattern.quote(username) : username;
                RefPatternMatcher next = ExpandParameters.getMatcher(this.expand(this.template, u, accountId = user.isIdentifiedUser() ? user.getAccountId() : null));
                if (next == null || !next.match(this.expand(ref, u, accountId), user)) continue;
                return true;
            }
            return false;
        }

        private Iterable<String> getUsernames(CurrentUser user) {
            if (user.isIdentifiedUser()) {
                Set<String> emails = user.asIdentifiedUser().getEmailAddresses();
                if (user.getUserName() == null) {
                    return emails;
                }
                if (emails.isEmpty()) {
                    return ImmutableSet.of(user.getUserName());
                }
                return Iterables.concat(emails, ImmutableSet.of(user.getUserName()));
            }
            if (user.getUserName() != null) {
                return ImmutableSet.of(user.getUserName());
            }
            return ImmutableSet.of();
        }

        boolean matchPrefix(String ref) {
            return ref.startsWith(this.prefix);
        }

        private String expand(String parameterizedRef, String userName, Account.Id accountId) {
            if (parameterizedRef.contains("${")) {
                return this.expand(new ParameterizedString(parameterizedRef), userName, accountId);
            }
            return parameterizedRef;
        }

        private String expand(ParameterizedString parameterizedRef, String userName, Account.Id accountId) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("username", userName);
            if (accountId != null) {
                params.put("shardeduserid", RefNames.shard(accountId.get()));
            }
            return parameterizedRef.replace(params);
        }
    }

    private static class Regexp
    extends RefPatternMatcher {
        private final Pattern pattern;

        Regexp(String re) {
            this.pattern = Pattern.compile(re);
        }

        @Override
        public boolean match(String ref, CurrentUser user) {
            return this.pattern.matcher(ref).matches();
        }
    }

    private static class Prefix
    extends RefPatternMatcher {
        private final String prefix;

        Prefix(String pfx) {
            this.prefix = pfx;
        }

        @Override
        public boolean match(String ref, CurrentUser user) {
            return ref.startsWith(this.prefix);
        }
    }

    private static class Exact
    extends RefPatternMatcher {
        private final String expect;

        Exact(String name) {
            this.expect = name;
        }

        @Override
        public boolean match(String ref, CurrentUser user) {
            return this.expect.equals(ref);
        }
    }
}

