/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.gerrit.server.query.AndPredicate;
import com.google.gerrit.server.query.DataSource;
import com.google.gerrit.server.query.IsVisibleToPredicate;
import com.google.gerrit.server.query.Paginated;
import com.google.gerrit.server.query.Predicate;
import com.google.gwtorm.server.ListResultSet;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.OrmRuntimeException;
import com.google.gwtorm.server.ResultSet;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class AndSource<T>
extends AndPredicate<T>
implements DataSource<T>,
Comparator<Predicate<T>> {
    protected final DataSource<T> source;
    private final IsVisibleToPredicate<T> isVisibleToPredicate;
    private final int start;
    private final int cardinality;

    public AndSource(Collection<? extends Predicate<T>> that) {
        this(that, null, 0);
    }

    public AndSource(Predicate<T> that, IsVisibleToPredicate<T> isVisibleToPredicate) {
        this(that, isVisibleToPredicate, 0);
    }

    public AndSource(Predicate<T> that, IsVisibleToPredicate<T> isVisibleToPredicate, int start) {
        this(ImmutableList.of(that), isVisibleToPredicate, start);
    }

    public AndSource(Collection<? extends Predicate<T>> that, IsVisibleToPredicate<T> isVisibleToPredicate, int start) {
        super(that);
        Preconditions.checkArgument(start >= 0, "negative start: %s", start);
        this.isVisibleToPredicate = isVisibleToPredicate;
        this.start = start;
        int c = Integer.MAX_VALUE;
        DataSource s = null;
        int minCost = Integer.MAX_VALUE;
        for (Predicate p : this.sort(this.getChildren())) {
            if (!(p instanceof DataSource)) continue;
            c = Math.min(c, ((DataSource)((Object)p)).getCardinality());
            int cost = p.estimateCost();
            if (cost >= minCost) continue;
            s = this.toDataSource(p);
            minCost = cost;
        }
        this.source = s;
        this.cardinality = c;
    }

    @Override
    public ResultSet<T> read() throws OrmException {
        try {
            return this.readImpl();
        }
        catch (OrmRuntimeException err) {
            if (err.getCause() != null) {
                Throwables.throwIfInstanceOf(err.getCause(), OrmException.class);
            }
            throw new OrmException(err);
        }
    }

    private ResultSet<T> readImpl() throws OrmException {
        if (this.source == null) {
            throw new OrmException("No DataSource: " + this);
        }
        AbstractCollection r = new ArrayList<T>();
        Object last = null;
        int nextStart = 0;
        boolean skipped = false;
        for (T data : this.buffer(this.source.read())) {
            if (!this.isMatchable() || this.match(data)) {
                r.add(data);
            } else {
                skipped = true;
            }
            last = data;
            ++nextStart;
        }
        if (skipped && last != null && this.source instanceof Paginated) {
            Paginated p = (Paginated)((Object)this.source);
            while (skipped && r.size() < p.getOptions().limit() + this.start) {
                skipped = false;
                ResultSet next = p.restart(nextStart);
                for (Object data : this.buffer(next)) {
                    if (this.match(data)) {
                        r.add(data);
                    } else {
                        skipped = true;
                    }
                    ++nextStart;
                }
            }
        }
        if (this.start >= r.size()) {
            r = ImmutableList.of();
        } else if (this.start > 0) {
            r = ImmutableList.copyOf(r.subList(this.start, r.size()));
        }
        return new ListResultSet(r);
    }

    @Override
    public boolean isMatchable() {
        return this.isVisibleToPredicate != null || super.isMatchable();
    }

    @Override
    public boolean match(T object) throws OrmException {
        if (this.isVisibleToPredicate != null && !this.isVisibleToPredicate.match(object)) {
            return false;
        }
        return !super.isMatchable() || super.match(object);
    }

    private Iterable<T> buffer(ResultSet<T> scanner) {
        return FluentIterable.from(Iterables.partition(scanner, 50)).transformAndConcat(this::transformBuffer);
    }

    protected List<T> transformBuffer(List<T> buffer) throws OrmRuntimeException {
        return buffer;
    }

    @Override
    public int getCardinality() {
        return this.cardinality;
    }

    private List<Predicate<T>> sort(Collection<? extends Predicate<T>> that) {
        ArrayList<Predicate<T>> r = new ArrayList<Predicate<T>>(that);
        Collections.sort(r, this);
        return r;
    }

    @Override
    public int compare(Predicate<T> a, Predicate<T> b) {
        int bi;
        int ai = a instanceof DataSource ? 0 : 1;
        int cmp = ai - (bi = b instanceof DataSource ? 0 : 1);
        if (cmp == 0) {
            cmp = a.estimateCost() - b.estimateCost();
        }
        if (cmp == 0 && a instanceof DataSource && b instanceof DataSource) {
            DataSource as = (DataSource)((Object)a);
            DataSource bs = (DataSource)((Object)b);
            cmp = as.getCardinality() - bs.getCardinality();
        }
        return cmp;
    }

    private DataSource<T> toDataSource(Predicate<T> pred) {
        return (DataSource)((Object)pred);
    }
}

