/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.change;

import com.google.gerrit.server.query.AndSource;
import com.google.gerrit.server.query.IsVisibleToPredicate;
import com.google.gerrit.server.query.Predicate;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.ChangeDataSource;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.OrmRuntimeException;
import java.util.Collection;
import java.util.List;

public class AndChangeSource
extends AndSource<ChangeData>
implements ChangeDataSource {
    public AndChangeSource(Collection<Predicate<ChangeData>> that) {
        super(that);
    }

    public AndChangeSource(Predicate<ChangeData> that, IsVisibleToPredicate<ChangeData> isVisibleToPredicate, int start) {
        super(that, isVisibleToPredicate, start);
    }

    @Override
    public boolean hasChange() {
        return this.source != null && this.source instanceof ChangeDataSource && ((ChangeDataSource)this.source).hasChange();
    }

    @Override
    protected List<ChangeData> transformBuffer(List<ChangeData> buffer) throws OrmRuntimeException {
        if (!this.hasChange()) {
            try {
                ChangeData.ensureChangeLoaded(buffer);
            }
            catch (OrmException e) {
                throw new OrmRuntimeException(e);
            }
        }
        return super.transformBuffer(buffer);
    }

    @Override
    public int compare(Predicate<ChangeData> a, Predicate<ChangeData> b) {
        int cmp = super.compare(a, b);
        if (cmp == 0 && a instanceof ChangeDataSource && b instanceof ChangeDataSource) {
            ChangeDataSource as = (ChangeDataSource)((Object)a);
            ChangeDataSource bs = (ChangeDataSource)((Object)b);
            cmp = (as.hasChange() ? 0 : 1) - (bs.hasChange() ? 0 : 1);
        }
        return cmp;
    }
}

