/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.group;

import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.server.index.FieldDef;
import com.google.gerrit.server.index.IndexPredicate;
import com.google.gerrit.server.index.group.GroupField;
import com.google.gerrit.server.query.Predicate;
import java.util.Locale;

public class GroupPredicates {
    public static Predicate<AccountGroup> uuid(AccountGroup.UUID uuid) {
        return new GroupPredicate(GroupField.UUID, "uuid", uuid.get());
    }

    public static Predicate<AccountGroup> description(String description) {
        return new GroupPredicate(GroupField.DESCRIPTION, "description", description);
    }

    public static Predicate<AccountGroup> inname(String name) {
        return new GroupPredicate(GroupField.NAME_PART, "inname", name.toLowerCase(Locale.US));
    }

    public static Predicate<AccountGroup> name(String name) {
        return new GroupPredicate(GroupField.NAME, "name", name.toLowerCase(Locale.US));
    }

    public static Predicate<AccountGroup> owner(AccountGroup.UUID ownerUuid) {
        return new GroupPredicate(GroupField.OWNER_UUID, "owner", ownerUuid.get());
    }

    public static Predicate<AccountGroup> isVisibleToAll() {
        return new GroupPredicate(GroupField.IS_VISIBLE_TO_ALL, "1");
    }

    private GroupPredicates() {
    }

    static class GroupPredicate
    extends IndexPredicate<AccountGroup> {
        GroupPredicate(FieldDef<AccountGroup, ?> def, String value) {
            super(def, value);
        }

        GroupPredicate(FieldDef<AccountGroup, ?> def, String name, String value) {
            super(def, name, value);
        }
    }
}

