/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.schema;

import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.config.SitePaths;
import com.google.gerrit.server.config.ThreadSettingsConfig;
import com.google.gerrit.server.schema.JdbcAccountPatchReviewStore;
import com.google.gwtorm.server.OrmDuplicateKeyException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.sql.SQLException;
import org.eclipse.jgit.lib.Config;

@Singleton
public class PostgresqlAccountPatchReviewStore
extends JdbcAccountPatchReviewStore {
    @Inject
    PostgresqlAccountPatchReviewStore(@GerritServerConfig Config cfg, SitePaths sitePaths, ThreadSettingsConfig threadSettingsConfig) {
        super(cfg, sitePaths, threadSettingsConfig);
    }

    @Override
    public OrmException convertError(String op, SQLException err) {
        switch (PostgresqlAccountPatchReviewStore.getSQLStateInt(err)) {
            case 23505: {
                return new OrmDuplicateKeyException("ACCOUNT_PATCH_REVIEWS", err);
            }
        }
        if (err.getCause() == null && err.getNextException() != null) {
            err.initCause(err.getNextException());
        }
        return new OrmException(op + " failure on ACCOUNT_PATCH_REVIEWS", err);
    }
}

