/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.schema;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.GroupCollector;
import com.google.gerrit.server.project.NoSuchChangeException;
import com.google.gerrit.server.schema.SchemaVersion;
import com.google.gerrit.server.schema.Schema_107;
import com.google.gerrit.server.schema.UpdateUI;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevWalk;

public class Schema_108
extends SchemaVersion {
    private final GitRepositoryManager repoManager;

    @Inject
    Schema_108(Provider<Schema_107> prior, GitRepositoryManager repoManager) {
        super(prior);
        this.repoManager = repoManager;
    }

    @Override
    protected void migrateData(ReviewDb db, UpdateUI ui) throws OrmException {
        ui.message("Listing all changes ...");
        SetMultimap<Project.NameKey, Change.Id> openByProject = this.getOpenChangesByProject(db, ui);
        ui.message("done");
        ui.message("Updating groups for open changes ...");
        int i = 0;
        for (Map.Entry<Project.NameKey, Collection<Change.Id>> e : openByProject.asMap().entrySet()) {
            try (Repository repo = this.repoManager.openRepository(e.getKey());
                 RevWalk rw = new RevWalk(repo);){
                this.updateProjectGroups(db, repo, rw, (Set)e.getValue(), ui);
            }
            catch (NoSuchChangeException | IOException err) {
                throw new OrmException(err);
            }
            if (++i % 100 != 0) continue;
            ui.message("  done " + i + " projects ...");
        }
        ui.message("done");
    }

    private void updateProjectGroups(ReviewDb db, Repository repo, RevWalk rw, Set<Change.Id> changes, UpdateUI ui) throws OrmException, IOException {
        RevCommit c;
        rw.reset();
        rw.sort(RevSort.TOPO);
        rw.sort(RevSort.REVERSE, true);
        RefDatabase refdb = repo.getRefDatabase();
        for (Ref ref : refdb.getRefs("refs/heads/").values()) {
            RevCommit c2 = Schema_108.maybeParseCommit(rw, ref.getObjectId(), ui);
            if (c2 == null) continue;
            rw.markUninteresting(c2);
        }
        Multimap changeRefsBySha = MultimapBuilder.hashKeys().arrayListValues().build();
        Multimap patchSetsBySha = MultimapBuilder.hashKeys().arrayListValues().build();
        for (Ref ref : refdb.getRefs("refs/changes/").values()) {
            ObjectId id = ref.getObjectId();
            if (ref.getObjectId() == null) continue;
            id = id.copy();
            changeRefsBySha.put(id, ref);
            PatchSet.Id psId = PatchSet.Id.fromRef(ref.getName());
            if (psId == null || !changes.contains(psId.getParentKey())) continue;
            patchSetsBySha.put(id, psId);
            RevCommit c3 = Schema_108.maybeParseCommit(rw, id, ui);
            if (c3 == null) continue;
            rw.markStart(c3);
        }
        GroupCollector collector = GroupCollector.createForSchemaUpgradeOnly((ListMultimap<ObjectId, Ref>)changeRefsBySha, db);
        while ((c = rw.next()) != null) {
            collector.visit(c);
        }
        Schema_108.updateGroups(db, collector, (ListMultimap<ObjectId, PatchSet.Id>)patchSetsBySha);
    }

    private static void updateGroups(ReviewDb db, GroupCollector collector, ListMultimap<ObjectId, PatchSet.Id> patchSetsBySha) throws OrmException {
        Map patchSets = db.patchSets().toMap(db.patchSets().get(patchSetsBySha.values()));
        for (Map.Entry<ObjectId, Collection<String>> e : collector.getGroups().asMap().entrySet()) {
            for (PatchSet.Id psId : patchSetsBySha.get((Object)e.getKey())) {
                PatchSet ps = (PatchSet)patchSets.get(psId);
                if (ps == null) continue;
                ps.setGroups(ImmutableList.copyOf(e.getValue()));
            }
        }
        db.patchSets().update(patchSets.values());
    }

    private SetMultimap<Project.NameKey, Change.Id> getOpenChangesByProject(ReviewDb db, UpdateUI ui) throws OrmException {
        SortedSet<Project.NameKey> projects = this.repoManager.list();
        TreeSet<Project.NameKey> nonExistentProjects = Sets.newTreeSet();
        Multimap openByProject = MultimapBuilder.hashKeys().hashSetValues().build();
        for (Change c : db.changes().all()) {
            Change.Status status = c.getStatus();
            if (status != null && status.isClosed()) continue;
            Project.NameKey projectKey = c.getProject();
            if (!projects.contains(projectKey)) {
                nonExistentProjects.add(projectKey);
                continue;
            }
            openByProject.put(projectKey, c.getId());
        }
        if (!nonExistentProjects.isEmpty()) {
            ui.message("Detected open changes referring to the following non-existent projects:");
            ui.message(Joiner.on(", ").join(nonExistentProjects));
            ui.message("It is highly recommended to remove\nthe obsolete open changes, comments and patch-sets from your DB.\n");
        }
        return openByProject;
    }

    private static RevCommit maybeParseCommit(RevWalk rw, ObjectId id, UpdateUI ui) throws IOException {
        if (id != null) {
            try {
                RevObject obj = rw.parseAny(id);
                return obj instanceof RevCommit ? (RevCommit)obj : null;
            }
            catch (MissingObjectException moe) {
                ui.message("Missing object: " + id.getName() + "\n");
            }
        }
        return null;
    }
}

