/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.update;

import com.google.common.base.Preconditions;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.update.Order;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.TimeZone;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevWalk;

public interface Context {
    public Project.NameKey getProject();

    public Repository getRepository() throws IOException;

    public RevWalk getRevWalk() throws IOException;

    public Timestamp getWhen();

    public TimeZone getTimeZone();

    public ReviewDb getDb();

    public CurrentUser getUser();

    public Order getOrder();

    default public IdentifiedUser getIdentifiedUser() {
        return Preconditions.checkNotNull(this.getUser()).asIdentifiedUser();
    }

    default public Account getAccount() {
        return this.getIdentifiedUser().getAccount();
    }

    default public Account.Id getAccountId() {
        return this.getIdentifiedUser().getAccountId();
    }
}

