/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd.commands;

import com.google.gerrit.extensions.annotations.RequiresAnyCapability;
import com.google.gerrit.server.project.Index;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.server.project.ProjectResource;
import com.google.gerrit.sshd.BaseCommand;
import com.google.gerrit.sshd.CommandMetaData;
import com.google.gerrit.sshd.SshCommand;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.kohsuke.args4j.Argument;

@RequiresAnyCapability(value={"maintainServer"})
@CommandMetaData(name="project", description="Index changes of a project")
final class IndexProjectCommand
extends SshCommand {
    @Inject
    private Index index;
    @Argument(index=0, required=true, multiValued=true, metaVar="PROJECT", usage="projects for which the changes should be indexed")
    private List<ProjectControl> projects = new ArrayList<ProjectControl>();

    IndexProjectCommand() {
    }

    @Override
    protected void run() throws BaseCommand.UnloggedFailure, BaseCommand.Failure, Exception {
        if (this.projects.isEmpty()) {
            throw this.die("needs at least one project as command arguments");
        }
        this.projects.stream().forEach(this::index);
    }

    private void index(ProjectControl projectControl) {
        try {
            this.index.apply(new ProjectResource(projectControl), null);
        }
        catch (Exception e) {
            this.writeError("error", String.format("Unable to index %s: %s", projectControl.getProject().getName(), e.getMessage()));
        }
    }
}

