/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd.commands;

import com.google.common.base.MoreObjects;
import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.TopLevelResource;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.server.account.AccountCache;
import com.google.gerrit.server.account.GroupCache;
import com.google.gerrit.server.group.AddIncludedGroups;
import com.google.gerrit.server.group.AddMembers;
import com.google.gerrit.server.group.DeleteIncludedGroups;
import com.google.gerrit.server.group.DeleteMembers;
import com.google.gerrit.server.group.GroupResource;
import com.google.gerrit.server.group.GroupsCollection;
import com.google.gerrit.sshd.BaseCommand;
import com.google.gerrit.sshd.CommandMetaData;
import com.google.gerrit.sshd.SshCommand;
import com.google.inject.Inject;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

@CommandMetaData(name="set-members", description="Modify members of specific group or number of groups")
public class SetMembersCommand
extends SshCommand {
    @Option(name="--add", aliases={"-a"}, metaVar="USER", usage="users that should be added as group member")
    private List<Account.Id> accountsToAdd = new ArrayList<Account.Id>();
    @Option(name="--remove", aliases={"-r"}, metaVar="USER", usage="users that should be removed from the group")
    private List<Account.Id> accountsToRemove = new ArrayList<Account.Id>();
    @Option(name="--include", aliases={"-i"}, metaVar="GROUP", usage="group that should be included as group member")
    private List<AccountGroup.UUID> groupsToInclude = new ArrayList<AccountGroup.UUID>();
    @Option(name="--exclude", aliases={"-e"}, metaVar="GROUP", usage="group that should be excluded from the group")
    private List<AccountGroup.UUID> groupsToRemove = new ArrayList<AccountGroup.UUID>();
    @Argument(index=0, required=true, multiValued=true, metaVar="GROUP", usage="groups to modify")
    private List<AccountGroup.UUID> groups = new ArrayList<AccountGroup.UUID>();
    @Inject
    private AddMembers addMembers;
    @Inject
    private DeleteMembers deleteMembers;
    @Inject
    private AddIncludedGroups addIncludedGroups;
    @Inject
    private DeleteIncludedGroups deleteIncludedGroups;
    @Inject
    private GroupsCollection groupsCollection;
    @Inject
    private GroupCache groupCache;
    @Inject
    private AccountCache accountCache;

    @Override
    protected void run() throws BaseCommand.UnloggedFailure, BaseCommand.Failure, Exception {
        try {
            for (AccountGroup.UUID groupUuid : this.groups) {
                GroupResource resource = this.groupsCollection.parse(TopLevelResource.INSTANCE, IdString.fromUrl(groupUuid.get()));
                if (!this.accountsToRemove.isEmpty()) {
                    this.deleteMembers.apply(resource, this.fromMembers(this.accountsToRemove));
                    this.reportMembersAction("removed from", resource, this.accountsToRemove);
                }
                if (!this.groupsToRemove.isEmpty()) {
                    this.deleteIncludedGroups.apply(resource, this.fromGroups(this.groupsToRemove));
                    this.reportGroupsAction("excluded from", resource, this.groupsToRemove);
                }
                if (!this.accountsToAdd.isEmpty()) {
                    this.addMembers.apply(resource, this.fromMembers(this.accountsToAdd));
                    this.reportMembersAction("added to", resource, this.accountsToAdd);
                }
                if (this.groupsToInclude.isEmpty()) continue;
                this.addIncludedGroups.apply(resource, this.fromGroups(this.groupsToInclude));
                this.reportGroupsAction("included to", resource, this.groupsToInclude);
            }
        }
        catch (RestApiException e) {
            throw this.die(e.getMessage());
        }
    }

    private void reportMembersAction(String action, GroupResource group, List<Account.Id> accountIdList) throws UnsupportedEncodingException, IOException {
        String names = accountIdList.stream().map(accountId -> MoreObjects.firstNonNull(this.accountCache.get((Account.Id)accountId).getAccount().getPreferredEmail(), "n/a")).collect(Collectors.joining(", "));
        this.out.write(String.format("Members %s group %s: %s\n", action, group.getName(), names).getBytes(ENC));
    }

    private void reportGroupsAction(String action, GroupResource group, List<AccountGroup.UUID> groupUuidList) throws UnsupportedEncodingException, IOException {
        String names = groupUuidList.stream().map(uuid -> this.groupCache.get((AccountGroup.UUID)uuid).getName()).collect(Collectors.joining(", "));
        this.out.write(String.format("Groups %s group %s: %s\n", action, group.getName(), names).getBytes(ENC));
    }

    private AddIncludedGroups.Input fromGroups(List<AccountGroup.UUID> accounts) {
        return AddIncludedGroups.Input.fromGroups(accounts.stream().map(Object::toString).collect(Collectors.toList()));
    }

    private AddMembers.Input fromMembers(List<Account.Id> accounts) {
        return AddMembers.Input.fromMembers(accounts.stream().map(Object::toString).collect(Collectors.toList()));
    }
}

