/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.basicfunctions;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.restricted.FloatData;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.NumberData;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.internal.targetexpr.TargetExpr;
import com.google.template.soy.jssrc.dsl.SoyJsPluginUtils;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.SoyJsSrcFunction;
import com.google.template.soy.pysrc.restricted.PyExpr;
import com.google.template.soy.pysrc.restricted.SoyPySrcFunction;
import com.google.template.soy.shared.restricted.SoyJavaFunction;
import com.google.template.soy.shared.restricted.SoyPureFunction;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
@SoyPureFunction
public final class RoundFunction
implements SoyJavaFunction,
SoyJsSrcFunction,
SoyPySrcFunction {
    @Inject
    RoundFunction() {
    }

    @Override
    public String getName() {
        return "round";
    }

    @Override
    public Set<Integer> getValidArgsSizes() {
        return ImmutableSet.of(Integer.valueOf(1), Integer.valueOf(2));
    }

    @Override
    public SoyValue computeForJava(List<SoyValue> args) {
        SoyValue value = args.get(0);
        int numDigitsAfterPt = args.size() == 2 ? args.get(1).integerValue() : 0;
        return RoundFunction.round(value, numDigitsAfterPt);
    }

    public static NumberData round(SoyValue value, int numDigitsAfterPoint) {
        if (numDigitsAfterPoint == 0) {
            return IntegerData.forValue(RoundFunction.round(value));
        }
        if (numDigitsAfterPoint > 0) {
            double valueDouble = value.numberValue();
            double shift = Math.pow(10.0, numDigitsAfterPoint);
            return FloatData.forValue((double)Math.round(valueDouble * shift) / shift);
        }
        double valueDouble = value.numberValue();
        double shift = Math.pow(10.0, -numDigitsAfterPoint);
        return IntegerData.forValue((int)((double)Math.round(valueDouble / shift) * shift));
    }

    public static long round(SoyValue value) {
        if (value instanceof IntegerData) {
            return value.longValue();
        }
        return Math.round(value.numberValue());
    }

    @Override
    public JsExpr computeForJsSrc(List<JsExpr> args) {
        JsExpr value = args.get(0);
        JsExpr numDigitsAfterPt = args.size() == 2 ? args.get(1) : null;
        int numDigitsAfterPtAsInt = RoundFunction.convertNumDigits(numDigitsAfterPt);
        if (numDigitsAfterPtAsInt == 0) {
            return new JsExpr("Math.round(" + value.getText() + ")", Integer.MAX_VALUE);
        }
        if (numDigitsAfterPtAsInt >= 0 && numDigitsAfterPtAsInt <= 12 || numDigitsAfterPtAsInt == Integer.MIN_VALUE) {
            String shiftExprText = numDigitsAfterPtAsInt >= 0 && numDigitsAfterPtAsInt <= 12 ? "1" + "000000000000".substring(0, numDigitsAfterPtAsInt) : "Math.pow(10, " + numDigitsAfterPt.getText() + ")";
            JsExpr shift = new JsExpr(shiftExprText, Integer.MAX_VALUE);
            JsExpr valueTimesShift = SoyJsPluginUtils.genJsExprUsingSoySyntax(Operator.TIMES, Lists.newArrayList(value, shift));
            return new JsExpr("Math.round(" + valueTimesShift.getText() + ") / " + shift.getText(), Operator.DIVIDE_BY.getPrecedence());
        }
        if (numDigitsAfterPtAsInt < 0 && numDigitsAfterPtAsInt >= -12) {
            String shiftExprText = "1" + "000000000000".substring(0, -numDigitsAfterPtAsInt);
            JsExpr shift = new JsExpr(shiftExprText, Integer.MAX_VALUE);
            JsExpr valueDivideByShift = SoyJsPluginUtils.genJsExprUsingSoySyntax(Operator.DIVIDE_BY, Lists.newArrayList(value, shift));
            return new JsExpr("Math.round(" + valueDivideByShift.getText() + ") * " + shift.getText(), Operator.TIMES.getPrecedence());
        }
        throw new IllegalArgumentException("Second argument to round() function is " + numDigitsAfterPtAsInt + ", which is too large in magnitude.");
    }

    @Override
    public PyExpr computeForPySrc(List<PyExpr> args) {
        boolean isLiteral;
        PyExpr value = args.get(0);
        PyExpr precision = args.size() == 2 ? args.get(1) : null;
        int precisionAsInt = RoundFunction.convertNumDigits(precision);
        boolean bl = isLiteral = precisionAsInt != Integer.MIN_VALUE;
        if (precisionAsInt >= -12 && precisionAsInt <= 12 || !isLiteral) {
            String floatBreakdown = "math.frexp(" + value.getText() + ")";
            String precisionValue = isLiteral ? precisionAsInt + "" : precision.getText();
            StringBuilder roundedValue = new StringBuilder("round(").append('(').append(floatBreakdown).append("[0]").append(" + sys.float_info.epsilon)*2**").append(floatBreakdown).append("[1]").append(", ").append(precisionValue).append(")");
            return new PyExpr("runtime.simplify_num(" + roundedValue + ", " + precisionValue + ")", Integer.MAX_VALUE);
        }
        throw new IllegalArgumentException("Second argument to round() function is " + precisionAsInt + ", which is too large in magnitude.");
    }

    private static int convertNumDigits(TargetExpr numDigitsAfterPt) {
        int numDigitsAfterPtAsInt = 0;
        if (numDigitsAfterPt != null) {
            try {
                numDigitsAfterPtAsInt = Integer.parseInt(numDigitsAfterPt.getText());
            }
            catch (NumberFormatException nfe) {
                numDigitsAfterPtAsInt = Integer.MIN_VALUE;
            }
        }
        return numDigitsAfterPtAsInt;
    }
}

