/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.internalutils.NodeContentKinds;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.restricted.JsExprUtils;
import java.util.List;

public final class CodeChunkUtils {
    public static final CodeChunk.WithValue OPT_DATA = CodeChunk.id("opt_data");

    private CodeChunkUtils() {
    }

    public static CodeChunk.WithValue wrapAsSanitizedContent(SanitizedContent.ContentKind contentKind, CodeChunk.WithValue value, boolean isInternalBlock) {
        Preconditions.checkNotNull(contentKind);
        String ordainerFn = isInternalBlock ? NodeContentKinds.toJsSanitizedContentOrdainerForInternalBlocks(contentKind) : NodeContentKinds.toJsSanitizedContentOrdainer(contentKind);
        return CodeChunk.dottedId(ordainerFn).call(value);
    }

    public static CodeChunk.WithValue concatChunks(List<? extends CodeChunk.WithValue> chunks) {
        if (chunks.isEmpty()) {
            return CodeChunk.WithValue.LITERAL_EMPTY_STRING;
        }
        CodeChunk.WithValue accum = chunks.get(0);
        for (CodeChunk.WithValue withValue : chunks.subList(1, chunks.size())) {
            accum = accum.plus(withValue);
        }
        return accum;
    }

    public static CodeChunk.WithValue concatChunksForceString(List<? extends CodeChunk.WithValue> chunks) {
        if (!chunks.isEmpty() && chunks.get(0).isRepresentableAsSingleExpression() && JsExprUtils.isStringLiteral(chunks.get(0).assertExpr())) {
            return CodeChunkUtils.concatChunks(chunks);
        }
        if (chunks.size() > 1 && chunks.get(1).isRepresentableAsSingleExpression() && JsExprUtils.isStringLiteral(chunks.get(1).assertExpr())) {
            return CodeChunkUtils.concatChunks(chunks);
        }
        return CodeChunkUtils.concatChunks((List<? extends CodeChunk.WithValue>)((Object)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(CodeChunk.WithValue.LITERAL_EMPTY_STRING)).addAll(chunks)).build()));
    }
}

