/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.base.internal.LegacyInternalSyntaxException;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.internalutils.NodeContentKinds;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.soytree.AutoescapeMode;
import com.google.template.soy.soytree.CommandTagAttribute;
import com.google.template.soy.soytree.TemplateBasicNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateNodeBuilder;
import com.google.template.soy.soytree.Visibility;
import com.google.template.soy.soytree.defn.TemplateParam;
import java.util.List;
import javax.annotation.Nullable;

public class TemplateBasicNodeBuilder
extends TemplateNodeBuilder {
    private static final SoyErrorKind FULLY_QUALIFIED_NAME = SoyErrorKind.of("Soy V2 template names must be relative to the file namespace, i.e. a dot followed by an identifier.  Templates with fully qualified names are only allowed in legacy templates marked with the deprecatedV1=\"true\" attribute.");
    private static final SoyErrorKind PRIVATE_AND_VISIBILITY = SoyErrorKind.of("Cannot specify both private=\"true\" and visibility=\"{0}\".");

    public TemplateBasicNodeBuilder(TemplateNode.SoyFileHeaderInfo soyFileHeaderInfo, ErrorReporter errorReporter) {
        super(soyFileHeaderInfo, errorReporter);
    }

    @Override
    public TemplateBasicNodeBuilder setId(int id) {
        return (TemplateBasicNodeBuilder)super.setId(id);
    }

    @Override
    public TemplateBasicNodeBuilder setSourceLocation(SourceLocation location) {
        return (TemplateBasicNodeBuilder)super.setSourceLocation(location);
    }

    @Override
    public TemplateNodeBuilder setCommandValues(Identifier templateName, List<CommandTagAttribute> attrs) {
        this.cmdText = templateName.identifier() + " " + Joiner.on(' ').join(attrs);
        AutoescapeMode autoescapeMode = this.soyFileHeaderInfo.defaultAutoescapeMode;
        SanitizedContent.ContentKind kind = null;
        SourceLocation kindLocation = null;
        block20: for (CommandTagAttribute attribute : attrs) {
            Identifier name = attribute.getName();
            switch (name.identifier()) {
                case "private": {
                    if (!attribute.valueAsBoolean(this.errorReporter, false)) continue block20;
                    if (this.visibility != null) {
                        this.errorReporter.report(attribute.getName().location(), PRIVATE_AND_VISIBILITY, this.visibility.getAttributeValue());
                    }
                    this.visibility = Visibility.LEGACY_PRIVATE;
                    continue block20;
                }
                case "visibility": {
                    if (this.visibility != null) {
                        this.errorReporter.report(attribute.getName().location(), PRIVATE_AND_VISIBILITY, attribute.getValue());
                    }
                    this.visibility = attribute.valueAsVisibility(this.errorReporter);
                    continue block20;
                }
                case "autoescape": {
                    autoescapeMode = attribute.valueAsAutoescapeMode(this.errorReporter);
                    continue block20;
                }
                case "kind": {
                    kind = attribute.valueAsContentKind(this.errorReporter);
                    kindLocation = attribute.getValueLocation();
                    continue block20;
                }
                case "requirecss": {
                    this.setRequiredCssNamespaces(attribute.valueAsRequireCss(this.errorReporter));
                    continue block20;
                }
                case "cssbase": {
                    this.setCssBaseNamespace(attribute.valueAsCssBase(this.errorReporter));
                    continue block20;
                }
                case "deprecatedV1": {
                    this.markDeprecatedV1(attribute.valueAsBoolean(this.errorReporter, false));
                    continue block20;
                }
                case "stricthtml": {
                    this.strictHtmlMode = attribute.valueAsStrictHtmlMode(this.errorReporter);
                    continue block20;
                }
            }
            this.errorReporter.report(name.location(), CommandTagAttribute.UNSUPPORTED_ATTRIBUTE_KEY, name.identifier(), ImmutableList.of("private", "visibility", "autoescape", "kind", "requirecss", "cssbase", "deprecatedV1", "stricthtml"));
        }
        if (this.visibility == null) {
            this.visibility = Visibility.PUBLIC;
        }
        this.setAutoescapeInfo(autoescapeMode, kind, kindLocation);
        if (templateName.isPartialIdentifier()) {
            if (this.soyFileHeaderInfo.namespace == null) {
                throw LegacyInternalSyntaxException.createWithMetaInfo("Template has namespace-relative name, but file has no namespace declaration.", templateName.location());
            }
            this.setTemplateNames(this.soyFileHeaderInfo.namespace + templateName.identifier(), templateName.location(), templateName.identifier());
        } else {
            if (!this.isMarkedV1 && !templateName.isPartialIdentifier()) {
                this.errorReporter.report(templateName.location(), FULLY_QUALIFIED_NAME, new Object[0]);
            }
            this.setTemplateNames(templateName.identifier(), templateName.location(), null);
        }
        this.templateNameForUserMsgs = this.getTemplateName();
        return this;
    }

    public TemplateBasicNodeBuilder setCmdTextInfo(String templateName, @Nullable String partialTemplateName, Visibility visibility, AutoescapeMode autoescapeMode, SanitizedContent.ContentKind contentKind, ImmutableList<String> requiredCssNamespaces) {
        Preconditions.checkState(this.sourceLocation != null);
        Preconditions.checkState(this.cmdText == null);
        Preconditions.checkArgument(BaseUtils.isDottedIdentifier(templateName));
        Preconditions.checkArgument(partialTemplateName == null || BaseUtils.isIdentifierWithLeadingDot(partialTemplateName));
        Preconditions.checkArgument(contentKind != null == (autoescapeMode == AutoescapeMode.STRICT));
        this.setTemplateNames(templateName, this.sourceLocation, partialTemplateName);
        this.templateNameForUserMsgs = templateName;
        this.visibility = visibility;
        this.setAutoescapeInfo(autoescapeMode, contentKind, this.sourceLocation);
        this.setRequiredCssNamespaces(requiredCssNamespaces);
        StringBuilder cmdTextBuilder = new StringBuilder();
        cmdTextBuilder.append(partialTemplateName != null ? partialTemplateName : templateName);
        cmdTextBuilder.append(" autoescape=\"").append(autoescapeMode.getAttributeValue()).append('\"');
        if (contentKind != null) {
            cmdTextBuilder.append(" kind=\"").append(NodeContentKinds.toAttributeValue(contentKind)).append('\"');
        }
        if (visibility == Visibility.LEGACY_PRIVATE) {
            cmdTextBuilder.append(" private=\"true\"");
        }
        if (!requiredCssNamespaces.isEmpty()) {
            cmdTextBuilder.append(" requirecss=\"").append(Joiner.on(", ").join(requiredCssNamespaces)).append("\"");
        }
        this.cmdText = cmdTextBuilder.toString();
        return this;
    }

    @Override
    public TemplateBasicNodeBuilder setSoyDoc(String soyDoc, SourceLocation soyDocLocation) {
        return (TemplateBasicNodeBuilder)super.setSoyDoc(soyDoc, soyDocLocation);
    }

    @Override
    public TemplateBasicNodeBuilder addParams(Iterable<? extends TemplateParam> allParams) {
        return (TemplateBasicNodeBuilder)super.addParams(allParams);
    }

    @Override
    public TemplateBasicNode build() {
        Preconditions.checkState(this.id != null && this.cmdText != null);
        return new TemplateBasicNode(this, this.soyFileHeaderInfo, this.visibility, this.params);
    }
}

