/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import java.util.Set;

public enum Visibility {
    PRIVATE("private"),
    LEGACY_PRIVATE("legacy-private"),
    PUBLIC("public");

    private final String attributeValue;
    private static final ImmutableMap<String, Visibility> attrValuesToVisibilityLevels;

    private Visibility(String attributeValue) {
        this.attributeValue = attributeValue;
    }

    public String getAttributeValue() {
        return this.attributeValue;
    }

    public static Set<String> getAttributeValues() {
        return attrValuesToVisibilityLevels.keySet();
    }

    public static Visibility forAttributeValue(String attributeValue) {
        return attrValuesToVisibilityLevels.get(attributeValue);
    }

    static {
        ImmutableSortedMap.Builder<String, Visibility> builder = ImmutableSortedMap.naturalOrder();
        for (Visibility v : Visibility.values()) {
            ((ImmutableMap.Builder)builder).put(v.attributeValue, v);
        }
        attrValuesToVisibilityLevels = ((ImmutableMap.Builder)builder).build();
    }
}

