/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.prolog_cafe.lang;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.PushbackReader;

public class Token {
    public static boolean isSolo(int n) {
        return n == 33 || n == 59;
    }

    public static boolean isSymbol(int n) {
        switch (n) {
            case 35: 
            case 36: 
            case 38: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 58: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 92: 
            case 94: 
            case 96: 
            case 126: {
                return true;
            }
        }
        return false;
    }

    public static int read_token(StringBuffer stringBuffer, PushbackReader pushbackReader) throws IOException {
        int n = pushbackReader.read();
        if (n == -1) {
            stringBuffer.append("end_of_file");
            return -1;
        }
        if (Character.isDigit((char)n)) {
            int n2 = Token.read_number(n, stringBuffer, pushbackReader);
            if (n2 == 1) {
                n2 = 73;
            } else if (n2 == 2) {
                n2 = 68;
            }
            return n2;
        }
        if (Character.isLowerCase((char)n)) {
            int n3 = Token.read_word(n, stringBuffer, pushbackReader);
            if (n3 > 0) {
                n3 = 65;
            }
            return n3;
        }
        if (Character.isUpperCase((char)n) || n == 95) {
            int n4 = Token.read_word(n, stringBuffer, pushbackReader);
            if (n4 > 0) {
                n4 = 86;
            }
            return n4;
        }
        switch (n) {
            case 40: 
            case 41: 
            case 44: 
            case 91: 
            case 93: 
            case 123: 
            case 124: 
            case 125: {
                stringBuffer.append((char)n);
                return n;
            }
            case 46: {
                int n5 = pushbackReader.read();
                if (n5 == -1 || n5 <= 32) {
                    stringBuffer.append(".");
                    return 46;
                }
                pushbackReader.unread(n5);
                break;
            }
            case 37: {
                int n6;
                stringBuffer.append(" ");
                while ((n6 = pushbackReader.read()) != 10) {
                    if (n6 != -1) continue;
                    return 32;
                }
                return 32;
            }
            case 47: {
                int n7 = pushbackReader.read();
                if (n7 == 42) {
                    stringBuffer.append(" ");
                    while (true) {
                        if ((n7 = pushbackReader.read()) != 42) {
                            if (n7 != -1) continue;
                            stringBuffer.append("unexpected end_of_file");
                            return -2;
                        }
                        n7 = pushbackReader.read();
                        if (n7 == 47) {
                            return 32;
                        }
                        pushbackReader.unread(n7);
                    }
                }
                pushbackReader.unread(n7);
                break;
            }
            case 39: {
                int n8 = Token.read_quoted(n, stringBuffer, pushbackReader);
                if (n8 > 0) {
                    n8 = 65;
                }
                return n8;
            }
            case 34: {
                int n9 = Token.read_quoted(n, stringBuffer, pushbackReader);
                if (n9 > 0) {
                    n9 = 83;
                }
                return n9;
            }
        }
        if (Token.isSolo(n)) {
            stringBuffer.append((char)n);
            return 65;
        }
        if (Token.isSymbol(n)) {
            int n10 = Token.read_symbol(n, stringBuffer, pushbackReader);
            if (n10 > 0) {
                n10 = 65;
            }
            return n10;
        }
        stringBuffer.append(" ");
        return 32;
    }

    public static int read_number(int n, StringBuffer stringBuffer, PushbackReader pushbackReader) throws IOException {
        int n2;
        pushbackReader.unread(n);
        while (Character.isDigit((char)(n2 = pushbackReader.read()))) {
            stringBuffer.append((char)n2);
        }
        if (n2 != 46) {
            pushbackReader.unread(n2);
            return 1;
        }
        int n3 = pushbackReader.read();
        if (!Character.isDigit((char)n3)) {
            pushbackReader.unread(n3);
            pushbackReader.unread(n2);
            return 1;
        }
        stringBuffer.append((char)n2);
        pushbackReader.unread(n3);
        while (Character.isDigit((char)(n2 = pushbackReader.read()))) {
            stringBuffer.append((char)n2);
        }
        if (n2 != 69 && n2 != 101) {
            pushbackReader.unread(n2);
            return 2;
        }
        n3 = pushbackReader.read();
        if (n3 == 45 || n3 == 43) {
            int n4 = pushbackReader.read();
            if (!Character.isDigit((char)n4)) {
                pushbackReader.unread(n4);
                pushbackReader.unread(n3);
                pushbackReader.unread(n2);
                return 2;
            }
            stringBuffer.append((char)n2);
            stringBuffer.append((char)n3);
            pushbackReader.unread(n4);
        } else if (Character.isDigit((char)n3)) {
            stringBuffer.append((char)n2);
            pushbackReader.unread(n3);
        } else {
            pushbackReader.unread(n3);
            pushbackReader.unread(n2);
            return 2;
        }
        while (Character.isDigit((char)(n2 = pushbackReader.read()))) {
            stringBuffer.append((char)n2);
        }
        pushbackReader.unread(n2);
        return 2;
    }

    public static int read_word(int n, StringBuffer stringBuffer, PushbackReader pushbackReader) throws IOException {
        int n2;
        pushbackReader.unread(n);
        while (Character.isLetterOrDigit((char)(n2 = pushbackReader.read())) || n2 == 95) {
            stringBuffer.append((char)n2);
        }
        pushbackReader.unread(n2);
        return 1;
    }

    public static int read_quoted(int n, StringBuffer stringBuffer, PushbackReader pushbackReader) throws IOException {
        while (true) {
            int n2;
            if ((n2 = pushbackReader.read()) == -1 || n2 == 10) {
                pushbackReader.unread(n2);
                return -2;
            }
            if (n2 == n) {
                n2 = pushbackReader.read();
                if (n2 != n) {
                    pushbackReader.unread(n2);
                    return 1;
                }
                n2 = n;
            } else if (n2 == 92) {
                int n3 = Token.escapeSequences(stringBuffer, pushbackReader);
                if (n3 > 0) continue;
                return -2;
            }
            stringBuffer.append((char)n2);
        }
    }

    public static int escapeSequences(StringBuffer stringBuffer, PushbackReader pushbackReader) throws IOException {
        int n = pushbackReader.read();
        switch (n) {
            case 98: {
                stringBuffer.append('\b');
                break;
            }
            case 116: {
                stringBuffer.append('\t');
                break;
            }
            case 110: {
                stringBuffer.append('\n');
                break;
            }
            case 118: {
                stringBuffer.append('\u000b');
                break;
            }
            case 102: {
                stringBuffer.append('\f');
                break;
            }
            case 114: {
                stringBuffer.append('\r');
                break;
            }
            case 101: {
                stringBuffer.append('\u001b');
                break;
            }
            case 100: {
                stringBuffer.append('\u007f');
                break;
            }
            case 97: {
                stringBuffer.append('\u0007');
                break;
            }
            default: {
                stringBuffer.append((char)n);
                return 2;
            }
        }
        return 1;
    }

    public static int read_symbol(int n, StringBuffer stringBuffer, PushbackReader pushbackReader) throws IOException {
        int n2;
        stringBuffer.append((char)n);
        while (Token.isSymbol(n2 = pushbackReader.read())) {
            stringBuffer.append((char)n2);
        }
        pushbackReader.unread(n2);
        return 1;
    }

    public static void write_string(String string, PrintWriter printWriter) {
        printWriter.print(string);
    }

    public static void writeq_string(String string, PrintWriter printWriter) {
        char[] cArray = string.toCharArray();
        if (Token.getStringType(string) == 3) {
            printWriter.print("'");
            for (int i = 0; i < cArray.length; ++i) {
                if (cArray[i] == '\'') {
                    printWriter.print("\\'");
                    continue;
                }
                if (cArray[i] == '\\') {
                    printWriter.print("\\\\");
                    continue;
                }
                if (cArray[i] == '\b') {
                    printWriter.print("\\b");
                    continue;
                }
                if (cArray[i] == '\t') {
                    printWriter.print("\\t");
                    continue;
                }
                if (cArray[i] == '\n') {
                    printWriter.print("\\n");
                    continue;
                }
                if (cArray[i] == '\u000b') {
                    printWriter.print("\\v");
                    continue;
                }
                if (cArray[i] == '\f') {
                    printWriter.print("\\f");
                    continue;
                }
                if (cArray[i] == '\r') {
                    printWriter.print("\\r");
                    continue;
                }
                if (cArray[i] == '\u001b') {
                    printWriter.print("\\e");
                    continue;
                }
                if (cArray[i] == '\u007f') {
                    printWriter.print("\\d");
                    continue;
                }
                if (cArray[i] == '\u0007') {
                    printWriter.print("\\a");
                    continue;
                }
                printWriter.print(cArray[i]);
            }
            printWriter.print("'");
        } else {
            Token.write_string(string, printWriter);
        }
    }

    public static String toQuotedString(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
        char[] cArray = string.toCharArray();
        if (Token.getStringType(string) == 3) {
            stringBuffer.append("'");
            for (int i = 0; i < cArray.length; ++i) {
                if (cArray[i] == '\'') {
                    stringBuffer.append("\\'");
                    continue;
                }
                if (cArray[i] == '\\') {
                    stringBuffer.append("\\\\");
                    continue;
                }
                if (cArray[i] == '\b') {
                    stringBuffer.append("\\b");
                    continue;
                }
                if (cArray[i] == '\t') {
                    stringBuffer.append("\\t");
                    continue;
                }
                if (cArray[i] == '\n') {
                    stringBuffer.append("\\n");
                    continue;
                }
                if (cArray[i] == '\u000b') {
                    stringBuffer.append("\\v");
                    continue;
                }
                if (cArray[i] == '\f') {
                    stringBuffer.append("\\f");
                    continue;
                }
                if (cArray[i] == '\r') {
                    stringBuffer.append("\\r");
                    continue;
                }
                if (cArray[i] == '\u001b') {
                    stringBuffer.append("\\e");
                    continue;
                }
                if (cArray[i] == '\u007f') {
                    stringBuffer.append("\\d");
                    continue;
                }
                if (cArray[i] == '\u0007') {
                    stringBuffer.append("\\a");
                    continue;
                }
                stringBuffer.append(cArray[i]);
            }
            stringBuffer.append("'");
            return stringBuffer.toString();
        }
        return string;
    }

    public static int getStringType(String string) {
        if (string.equals("[]") || string.equals("{}")) {
            return 0;
        }
        if (string.equals("") || string.equals(".")) {
            return 3;
        }
        if (string.equals("!") || string.equals(";")) {
            return 2;
        }
        char[] cArray = string.toCharArray();
        if (Character.isLowerCase(cArray[0])) {
            for (int i = 1; i < cArray.length; ++i) {
                if (Character.isLetterOrDigit(cArray[i]) || cArray[i] == '_') continue;
                return 3;
            }
            return 0;
        }
        if (Token.isSymbol(cArray[0])) {
            for (int i = 1; i < cArray.length; ++i) {
                if (Token.isSymbol(cArray[i])) continue;
                return 3;
            }
            return 1;
        }
        return 3;
    }
}

