/*
 * Decompiled with CFR 0.152.
 */
package gerrit;

import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.rules.StoredValues;
import com.google.gerrit.server.AnonymousUser;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.PeerDaemonUser;
import com.googlecode.prolog_cafe.exceptions.EvaluationException;
import com.googlecode.prolog_cafe.exceptions.PrologException;
import com.googlecode.prolog_cafe.lang.IntegerTerm;
import com.googlecode.prolog_cafe.lang.Operation;
import com.googlecode.prolog_cafe.lang.Predicate;
import com.googlecode.prolog_cafe.lang.Prolog;
import com.googlecode.prolog_cafe.lang.StructureTerm;
import com.googlecode.prolog_cafe.lang.SymbolTerm;
import com.googlecode.prolog_cafe.lang.Term;

public class PRED_current_user_1
extends Predicate.P1 {
    private static final SymbolTerm user = SymbolTerm.intern("user", 1);
    private static final SymbolTerm anonymous = SymbolTerm.intern("anonymous");
    private static final SymbolTerm peerDaemon = SymbolTerm.intern("peer_daemon");

    public PRED_current_user_1(Term a1, Operation n) {
        this.arg1 = a1;
        this.cont = n;
    }

    @Override
    public Operation exec(Prolog engine) throws PrologException {
        Term resultTerm;
        engine.setB0();
        Term a1 = this.arg1.dereference();
        CurrentUser curUser = StoredValues.CURRENT_USER.getOrNull(engine);
        if (curUser == null) {
            throw new EvaluationException("Current user not available in this rule type");
        }
        if (curUser.isIdentifiedUser()) {
            Account.Id id = curUser.getAccountId();
            resultTerm = new IntegerTerm(id.get());
        } else if (curUser instanceof AnonymousUser) {
            resultTerm = anonymous;
        } else if (curUser instanceof PeerDaemonUser) {
            resultTerm = peerDaemon;
        } else {
            throw new EvaluationException("Unknown user type");
        }
        if (!a1.unify(new StructureTerm(user, resultTerm), engine.trail)) {
            return engine.fail();
        }
        return this.cont;
    }
}

