/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.security.eddsa;

import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.Provider;
import java.security.Signature;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ReflectionUtils;
import org.apache.sshd.common.util.security.AbstractSecurityProviderRegistrar;
import org.apache.sshd.common.util.threads.ThreadUtils;

public class EdDSASecurityProviderRegistrar
extends AbstractSecurityProviderRegistrar {
    public static final String PROVIDER_CLASS = "org.apache.sshd.common.util.security.eddsa.EdDSASecurityProvider";
    private final AtomicReference<Boolean> supportHolder = new AtomicReference<Object>(null);

    public EdDSASecurityProviderRegistrar() {
        super("EdDSA");
    }

    @Override
    public boolean isEnabled() {
        if (!super.isEnabled()) {
            return false;
        }
        return PropertyResolverUtils.getBooleanProperty(this, "org.apache.sshd.eddsaSupport", true);
    }

    @Override
    public Provider getSecurityProvider() {
        try {
            return this.getOrCreateProvider(PROVIDER_CLASS);
        }
        catch (ReflectiveOperationException t) {
            Throwable e = GenericUtils.peelException(t);
            this.log.error("getSecurityProvider({}) failed ({}) to instantiate {}: {}", this.getName(), e.getClass().getSimpleName(), PROVIDER_CLASS, e.getMessage());
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isSecurityEntitySupported(Class<?> entityType, String name) {
        if (!this.isSupported()) {
            return false;
        }
        if (KeyPairGenerator.class.isAssignableFrom(entityType) || KeyFactory.class.isAssignableFrom(entityType)) {
            return Objects.compare(name, this.getName(), String.CASE_INSENSITIVE_ORDER) == 0;
        }
        if (Signature.class.isAssignableFrom(entityType)) {
            return Objects.compare("ed25519-sha-512", name, String.CASE_INSENSITIVE_ORDER) == 0;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSupported() {
        Boolean supported;
        AtomicReference<Boolean> atomicReference = this.supportHolder;
        synchronized (atomicReference) {
            supported = this.supportHolder.get();
            if (supported != null) {
                return supported;
            }
            ClassLoader cl = ThreadUtils.resolveDefaultClassLoader(this.getClass());
            supported = ReflectionUtils.isClassAvailable(cl, "net.i2p.crypto.eddsa.EdDSAKey");
            this.supportHolder.set(supported);
        }
        return supported;
    }
}

