/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.matchers;

import com.google.common.base.Preconditions;
import org.parboiled.MatcherContext;
import org.parboiled.matchers.AbstractMatcher;
import org.parboiled.matchervisitors.MatcherVisitor;
import org.parboiled.support.Chars;

public class CharRangeMatcher
extends AbstractMatcher {
    public final char cLow;
    public final char cHigh;

    public CharRangeMatcher(char cLow, char cHigh) {
        super(Chars.escape(cLow) + ".." + Chars.escape(cHigh));
        Preconditions.checkArgument(cLow < cHigh);
        this.cLow = cLow;
        this.cHigh = cHigh;
    }

    @Override
    public <V> boolean match(MatcherContext<V> context) {
        char c = context.getCurrentChar();
        if (c < this.cLow || c > this.cHigh) {
            return false;
        }
        context.advanceIndex(1);
        context.createNode();
        return true;
    }

    @Override
    public <R> R accept(MatcherVisitor<R> visitor) {
        Preconditions.checkNotNull(visitor, "visitor");
        return visitor.visit(this);
    }
}

