/*
 * Decompiled with CFR 0.152.
 */
package com.github.parboiled1.grappa.matchers.unicode;

import com.github.parboiled1.grappa.matchers.unicode.BmpCharMatcher;
import com.github.parboiled1.grappa.matchers.unicode.SupplementaryCharMatcher;
import com.google.common.base.Preconditions;
import org.parboiled.matchers.CustomMatcher;
import org.parboiled.matchervisitors.MatcherVisitor;

public abstract class UnicodeCharMatcher
extends CustomMatcher {
    public static UnicodeCharMatcher forCodePoint(int codePoint) {
        String label = String.format("U+%04X", codePoint);
        char[] chars = Character.toChars(codePoint);
        return chars.length == 1 ? new BmpCharMatcher(label, chars[0]) : new SupplementaryCharMatcher(label, chars);
    }

    protected UnicodeCharMatcher(String label) {
        super(label);
    }

    @Override
    public <R> R accept(MatcherVisitor<R> visitor) {
        Preconditions.checkNotNull(visitor, "visitor");
        return visitor.visit(this);
    }
}

