/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.html.types;

import com.google.common.annotations.GwtCompatible;
import com.google.common.html.types.BuilderUtils;
import com.google.common.html.types.SafeHtml;
import com.google.common.html.types.SafeHtmls;
import com.google.common.html.types.SafeStyle;
import com.google.common.html.types.SafeUrl;
import com.google.common.html.types.TrustedResourceUrl;
import com.google.errorprone.annotations.CompileTimeConstant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
@GwtCompatible
public final class SafeHtmlBuilder {
    private static final String VALID_ELEMENT_NAMES_REGEXP = "[a-z0-9-]+";
    private static final String VALID_REL_VALUES_REGEXP = "[a-zA-Z ]+";
    private static final String VALID_DATA_ATTRIBUTES_REGEXP = "data-[a-zA-Z-]+";
    private static final Set<String> UNSUPPORTED_ELEMENTS = SafeHtmlBuilder.createUnmodifiableSet("applet", "base", "embed", "iframe", "math", "meta", "object", "script", "style", "svg", "template");
    private static final Set<String> VOID_ELEMENTS = SafeHtmlBuilder.createUnmodifiableSet("area", "base", "br", "col", "embed", "hr", "input", "img", "keygen", "link", "menuitem", "meta", "param", "source", "track", "wbr");
    private static final Set<String> TYPE_ELEMENTS_WHITELIST = SafeHtmlBuilder.createUnmodifiableSet("button", "command", "input", "li", "menu", "ol", "ul", "link");
    private static final Set<String> LINK_REL_ELEMENTS_WHITELIST = SafeHtmlBuilder.createUnmodifiableSet("alternate", "author", "bookmark", "canonical", "cite", "help", "icon", "license", "next", "prefetch", "prerender", "prev", "search", "subresource", "tag");
    private final String elementName;
    private final Map<String, String> attributes = new LinkedHashMap<String, String>();
    private final List<SafeHtml> contents = new ArrayList<SafeHtml>();
    private boolean hrefSetFromSafeUrl = false;
    private boolean useSlashOnVoid = false;

    public SafeHtmlBuilder(@CompileTimeConstant String elementName) {
        if (elementName == null) {
            throw new NullPointerException();
        }
        if (!elementName.matches(VALID_ELEMENT_NAMES_REGEXP)) {
            throw new IllegalArgumentException("Invalid element name \"" + elementName + "\". " + "Only lowercase letters, numbers and '-' allowed.");
        }
        if (UNSUPPORTED_ELEMENTS.contains(elementName)) {
            throw new IllegalArgumentException("Element \"" + elementName + "\" is not supported.");
        }
        this.elementName = elementName;
    }

    public SafeHtmlBuilder useSlashOnVoid() {
        this.useSlashOnVoid = true;
        return this;
    }

    public SafeHtmlBuilder setAlt(String value) {
        return this.setAttribute("alt", value);
    }

    public SafeHtmlBuilder setClass(String value) {
        return this.setAttribute("class", value);
    }

    public SafeHtmlBuilder setColor(String value) {
        return this.setAttribute("color", value);
    }

    public SafeHtmlBuilder setDataAttribute(@CompileTimeConstant String name, String value) {
        if (!name.matches(VALID_DATA_ATTRIBUTES_REGEXP)) {
            throw new IllegalArgumentException("Invalid data attribute name \"" + name + "\"." + "Name must start with \"data-\" and be followed by letters and '-'.");
        }
        return this.setAttribute(name, value);
    }

    public SafeHtmlBuilder setDir(DirValue value) {
        return this.setAttribute("dir", value.toString());
    }

    public SafeHtmlBuilder setHref(SafeUrl value) {
        String rel;
        if (this.elementName.equals("link") && (rel = this.attributes.get("rel")) != null && !LINK_REL_ELEMENTS_WHITELIST.contains(rel = rel.toLowerCase())) {
            throw new IllegalArgumentException("Attribute \"href\" on <link rel=\"" + rel + "\"> " + "is not whitelisted, TrustedResourceUrl required.");
        }
        this.hrefSetFromSafeUrl = true;
        return this.setAttribute("href", value.getSafeUrlString());
    }

    public SafeHtmlBuilder setHref(TrustedResourceUrl value) {
        this.hrefSetFromSafeUrl = false;
        return this.setAttribute("href", value.getTrustedResourceUrlString());
    }

    public SafeHtmlBuilder setId(@CompileTimeConstant String value) {
        return this.setAttribute("id", value);
    }

    public SafeHtmlBuilder setIdWithPrefix(@CompileTimeConstant String prefix, String value) {
        if (prefix.trim().length() == 0) {
            throw new IllegalArgumentException("Prefix cannot be empty string");
        }
        return this.setAttribute("id", prefix + "-" + value);
    }

    public SafeHtmlBuilder setName(String value) {
        return this.setAttribute("name", value);
    }

    public SafeHtmlBuilder setPlaceholder(String value) {
        return this.setAttribute("placeholder", value);
    }

    public SafeHtmlBuilder setSrc(SafeUrl value) {
        if (!this.elementName.equals("img") && !this.elementName.equals("input")) {
            throw new IllegalArgumentException("Attribute \"src\" cannot be set on element \"" + this.elementName + "\", TrustedResourceUrl required.");
        }
        return this.setAttribute("src", value.getSafeUrlString());
    }

    public SafeHtmlBuilder setSrc(TrustedResourceUrl value) {
        return this.setAttribute("src", value.getTrustedResourceUrlString());
    }

    public SafeHtmlBuilder setStyle(SafeStyle value) {
        return this.setAttribute("style", value.getSafeStyleString());
    }

    public SafeHtmlBuilder setRel(String value) {
        if (!value.matches(VALID_REL_VALUES_REGEXP)) {
            throw new IllegalArgumentException("Invalid value for \"rel\" attribute \"" + value + "\". " + "Only letters and spaces allowed.");
        }
        if (this.elementName.equals("link") && !LINK_REL_ELEMENTS_WHITELIST.contains(value.toLowerCase()) && this.hrefSetFromSafeUrl) {
            throw new IllegalArgumentException("Attribute \"rel\" equals \"" + value.toLowerCase() + "\" on <link href=\"...\"> loads code. TrustedResourceUrl required to set \"href\".");
        }
        return this.setAttribute("rel", value);
    }

    public SafeHtmlBuilder setType(String value) {
        if (!TYPE_ELEMENTS_WHITELIST.contains(this.elementName)) {
            throw new IllegalArgumentException("Attribute \"type\" can only be used by one of the following elements: " + TYPE_ELEMENTS_WHITELIST);
        }
        return this.setAttribute("type", value);
    }

    public SafeHtmlBuilder setValue(String value) {
        return this.setAttribute("value", value);
    }

    public SafeHtmlBuilder setTarget(TargetValue value) {
        return this.setAttribute("target", value.toString());
    }

    public SafeHtmlBuilder setTitle(String value) {
        return this.setAttribute("title", value);
    }

    public SafeHtmlBuilder appendContent(SafeHtml ... htmls) {
        this.checkNotVoidElement();
        Collections.addAll(this.contents, htmls);
        return this;
    }

    public SafeHtmlBuilder appendContent(Iterable<SafeHtml> htmls) {
        this.checkNotVoidElement();
        for (SafeHtml html : htmls) {
            this.contents.add(html);
        }
        return this;
    }

    public SafeHtmlBuilder appendContent(Iterator<SafeHtml> htmls) {
        this.checkNotVoidElement();
        while (htmls.hasNext()) {
            this.contents.add(htmls.next());
        }
        return this;
    }

    private void checkNotVoidElement() {
        if (VOID_ELEMENTS.contains(this.elementName)) {
            throw new IllegalStateException("Element \"" + this.elementName + "\" is a void element and so cannot have content.");
        }
    }

    public SafeHtmlBuilder escapeAndAppendContent(String text) {
        return this.appendContent(SafeHtmls.htmlEscape(text));
    }

    public SafeHtml build() {
        StringBuilder sb = new StringBuilder("<" + this.elementName);
        for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
            sb.append(" " + entry.getKey() + "=\"" + BuilderUtils.escapeHtmlInternal(entry.getValue()) + "\"");
        }
        boolean isVoid = VOID_ELEMENTS.contains(this.elementName);
        if (isVoid && this.useSlashOnVoid) {
            sb.append("/");
        }
        sb.append(">");
        if (!isVoid) {
            for (SafeHtml content : this.contents) {
                sb.append(content.getSafeHtmlString());
            }
            sb.append("</" + this.elementName + ">");
        }
        return SafeHtmls.create(sb.toString());
    }

    private static final Set<String> createUnmodifiableSet(String ... strings) {
        HashSet<String> set = new HashSet<String>();
        for (String string : strings) {
            set.add(string);
        }
        return Collections.unmodifiableSet(set);
    }

    private SafeHtmlBuilder setAttribute(@CompileTimeConstant String name, String value) {
        if (value == null) {
            throw new NullPointerException("setAttribute requires a non-null value.");
        }
        this.attributes.put(name, BuilderUtils.coerceToInterchangeValid(value));
        return this;
    }

    public static enum TargetValue {
        BLANK("_blank"),
        SELF("_self");

        private final String value;

        private TargetValue(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum DirValue {
        AUTO("auto"),
        LTR("ltr"),
        RTL("rtl");

        private final String value;

        private DirValue(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

