/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.html.types;

import com.google.common.annotations.GwtCompatible;
import com.google.common.html.types.SafeStyle;
import com.google.common.html.types.SafeStyleProto;
import com.google.errorprone.annotations.CompileTimeConstant;

@GwtCompatible
public final class SafeStyles {
    private SafeStyles() {
    }

    public static SafeStyle fromConstant(@CompileTimeConstant String style) {
        if (style.length() == 0) {
            return SafeStyle.EMPTY;
        }
        for (int i = 0; i < style.length(); ++i) {
            if (style.charAt(i) != '<' && style.charAt(i) != '>') continue;
            throw new IllegalArgumentException("Forbidden characters in style string: " + style);
        }
        if (style.charAt(style.length() - 1) != ';') {
            throw new IllegalArgumentException("Last character of style string is not ';': " + style);
        }
        if (!style.contains(":")) {
            throw new IllegalArgumentException("Style string must contain at least one ':', to specify a \"name: value\" pair: " + style);
        }
        return SafeStyles.create(style);
    }

    public static SafeStyle fromProto(SafeStyleProto proto) {
        return SafeStyles.create(proto.getPrivateDoNotAccessOrElseSafeStyleWrappedValue());
    }

    public static SafeStyleProto toProto(SafeStyle style) {
        return SafeStyleProto.newBuilder().setPrivateDoNotAccessOrElseSafeStyleWrappedValue(style.getSafeStyleString()).build();
    }

    static SafeStyle create(String style) {
        return new SafeStyle(style);
    }
}

