/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd;

import com.google.gerrit.extensions.registration.DynamicItem;
import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.httpd.HttpServletResponseRecorder;
import com.google.gerrit.httpd.WebLoginListener;
import com.google.gerrit.httpd.WebSession;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.servlet.ServletModule;
import java.io.IOException;
import java.util.Optional;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class UniversalWebLoginFilter
implements Filter {
    private final DynamicItem<WebSession> session;
    private final DynamicSet<WebLoginListener> webLoginListeners;
    private final Provider<CurrentUser> userProvider;

    public static ServletModule module() {
        return new ServletModule(){

            @Override
            protected void configureServlets() {
                this.filter("/login*", "/logout*").through(UniversalWebLoginFilter.class);
                this.bind(UniversalWebLoginFilter.class).in(Singleton.class);
                DynamicSet.setOf(this.binder(), WebLoginListener.class);
            }
        };
    }

    @Inject
    public UniversalWebLoginFilter(DynamicItem<WebSession> session, DynamicSet<WebLoginListener> webLoginListeners, Provider<CurrentUser> userProvider) {
        this.session = session;
        this.webLoginListeners = webLoginListeners;
        this.userProvider = userProvider;
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponseRecorder wrappedResponse = new HttpServletResponseRecorder((HttpServletResponse)response);
        Optional<IdentifiedUser> loggedInUserBefore = this.loggedInUser();
        chain.doFilter(request, wrappedResponse);
        Optional<IdentifiedUser> loggedInUserAfter = this.loggedInUser();
        if (!loggedInUserBefore.isPresent() && loggedInUserAfter.isPresent()) {
            for (WebLoginListener loginListener : this.webLoginListeners) {
                loginListener.onLogin(loggedInUserAfter.get(), httpRequest, wrappedResponse);
            }
        } else if (loggedInUserBefore.isPresent() && !loggedInUserAfter.isPresent()) {
            for (WebLoginListener loginListener : this.webLoginListeners) {
                loginListener.onLogout(loggedInUserBefore.get(), httpRequest, wrappedResponse);
            }
        }
        wrappedResponse.play();
    }

    private Optional<IdentifiedUser> loggedInUser() {
        return this.session.get().isSignedIn() ? Optional.of(this.userProvider.get().asIdentifiedUser()) : Optional.empty();
    }

    @Override
    public void destroy() {
    }
}

