/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd.restapi;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.io.BaseEncoding;
import com.google.common.io.CountingOutputStream;
import com.google.common.math.IntMath;
import com.google.gerrit.audit.AuditService;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.common.RawInputUtil;
import com.google.gerrit.extensions.registration.DynamicItem;
import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.restapi.AcceptsPost;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.BinaryResult;
import com.google.gerrit.extensions.restapi.CacheControl;
import com.google.gerrit.extensions.restapi.DefaultInput;
import com.google.gerrit.extensions.restapi.ETagView;
import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.MethodNotAllowedException;
import com.google.gerrit.extensions.restapi.PreconditionFailedException;
import com.google.gerrit.extensions.restapi.RawInput;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.RestCollection;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.restapi.RestResource;
import com.google.gerrit.extensions.restapi.RestView;
import com.google.gerrit.httpd.WebSession;
import com.google.gerrit.httpd.restapi.ParameterParser;
import com.google.gerrit.httpd.restapi.RestApiMetrics;
import com.google.gerrit.server.AccessPath;
import com.google.gerrit.server.AnonymousUser;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.OptionUtil;
import com.google.gerrit.server.OutputFormat;
import com.google.gerrit.server.account.CapabilityUtils;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.util.http.RequestUtil;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.google.gwtexpui.server.CacheHeaders;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.util.Providers;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.util.TemporaryBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestApiServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(RestApiServlet.class);
    private static final String JSON_TYPE = "application/json";
    private static final String FORM_TYPE = "application/x-www-form-urlencoded";
    private static final int SC_UNPROCESSABLE_ENTITY = 422;
    private static final String X_REQUESTED_WITH = "X-Requested-With";
    private static final ImmutableSet<String> ALLOWED_CORS_REQUEST_HEADERS = ImmutableSet.of("X-Requested-With");
    private static final int HEAP_EST_SIZE = 81920;
    public static final byte[] JSON_MAGIC = ")]}'\n".getBytes(StandardCharsets.UTF_8);
    private final Globals globals;
    private final Provider<RestCollection<RestResource, RestResource>> members;

    public RestApiServlet(Globals globals, RestCollection<? extends RestResource, ? extends RestResource> members) {
        this(globals, Providers.of(members));
    }

    public RestApiServlet(Globals globals, Provider<? extends RestCollection<? extends RestResource, ? extends RestResource>> members) {
        Provider<? extends RestCollection<? extends RestResource, ? extends RestResource>> n = Preconditions.checkNotNull(members);
        this.globals = globals;
        this.members = n;
    }

    /*
     * Exception decompiling
     */
    @Override
    protected final void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 11 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void checkCors(HttpServletRequest req, HttpServletResponse res) {
        String origin = req.getHeader("Origin");
        if (RestApiServlet.isRead(req) && !Strings.isNullOrEmpty(origin) && this.isOriginAllowed(origin)) {
            res.addHeader("Vary", "Origin");
            this.setCorsHeaders(res, origin);
        }
    }

    private static boolean isCorsPreflight(HttpServletRequest req) {
        return "OPTIONS".equals(req.getMethod()) && !Strings.isNullOrEmpty(req.getHeader("Origin")) && !Strings.isNullOrEmpty(req.getHeader("Access-Control-Request-Method"));
    }

    private void doCorsPreflight(HttpServletRequest req, HttpServletResponse res) throws BadRequestException {
        CacheHeaders.setNotCacheable(res);
        res.setHeader("Vary", Joiner.on(", ").join(ImmutableList.of("Origin", "Access-Control-Request-Method")));
        String origin = req.getHeader("Origin");
        if (Strings.isNullOrEmpty(origin) || !this.isOriginAllowed(origin)) {
            throw new BadRequestException("CORS not allowed");
        }
        String method = req.getHeader("Access-Control-Request-Method");
        if (!"GET".equals(method) && !"HEAD".equals(method)) {
            throw new BadRequestException(method + " not allowed in CORS");
        }
        String headers = req.getHeader("Access-Control-Request-Headers");
        if (headers != null) {
            res.addHeader("Vary", "Access-Control-Request-Headers");
            String badHeader = StreamSupport.stream(Splitter.on(',').trimResults().split(headers).spliterator(), false).filter(h -> !ALLOWED_CORS_REQUEST_HEADERS.contains(h)).findFirst().orElse(null);
            if (badHeader != null) {
                throw new BadRequestException(badHeader + " not allowed in CORS");
            }
        }
        res.setStatus(200);
        this.setCorsHeaders(res, origin);
        res.setContentType("text/plain");
        res.setContentLength(0);
    }

    private void setCorsHeaders(HttpServletResponse res, String origin) {
        res.setHeader("Access-Control-Allow-Origin", origin);
        res.setHeader("Access-Control-Allow-Credentials", "true");
        res.setHeader("Access-Control-Allow-Methods", "GET, OPTIONS");
        res.setHeader("Access-Control-Allow-Headers", Joiner.on(", ").join(ALLOWED_CORS_REQUEST_HEADERS));
    }

    private boolean isOriginAllowed(String origin) {
        return this.globals.allowOrigin != null && this.globals.allowOrigin.matcher(origin).matches();
    }

    private static String messageOr(Throwable t, String defaultMessage) {
        if (!Strings.isNullOrEmpty(t.getMessage())) {
            return t.getMessage();
        }
        return defaultMessage;
    }

    private static boolean notModified(HttpServletRequest req, RestResource rsrc, RestView<RestResource> view) {
        String have;
        if (!RestApiServlet.isRead(req)) {
            return false;
        }
        if (view instanceof ETagView && (have = req.getHeader("If-None-Match")) != null) {
            return have.equals(((ETagView)view).getETag(rsrc));
        }
        if (rsrc instanceof RestResource.HasETag && (have = req.getHeader("If-None-Match")) != null) {
            return have.equals(((RestResource.HasETag)((Object)rsrc)).getETag());
        }
        if (rsrc instanceof RestResource.HasLastModified) {
            Timestamp m = ((RestResource.HasLastModified)((Object)rsrc)).getLastModified();
            long d = req.getDateHeader("If-Modified-Since");
            return d / 1000L == m.getTime() / 1000L;
        }
        return false;
    }

    private static <R extends RestResource> void configureCaching(HttpServletRequest req, HttpServletResponse res, R rsrc, RestView<R> view, CacheControl c) {
        if (RestApiServlet.isRead(req)) {
            switch (c.getType()) {
                default: {
                    CacheHeaders.setNotCacheable(res);
                    break;
                }
                case PRIVATE: {
                    RestApiServlet.addResourceStateHeaders(res, rsrc, view);
                    CacheHeaders.setCacheablePrivate(res, c.getAge(), c.getUnit(), c.isMustRevalidate());
                    break;
                }
                case PUBLIC: {
                    RestApiServlet.addResourceStateHeaders(res, rsrc, view);
                    CacheHeaders.setCacheable(req, res, c.getAge(), c.getUnit(), c.isMustRevalidate());
                    break;
                }
            }
        } else {
            CacheHeaders.setNotCacheable(res);
        }
    }

    private static <R extends RestResource> void addResourceStateHeaders(HttpServletResponse res, R rsrc, RestView<R> view) {
        if (view instanceof ETagView) {
            res.setHeader("ETag", ((ETagView)view).getETag(rsrc));
        } else if (rsrc instanceof RestResource.HasETag) {
            res.setHeader("ETag", ((RestResource.HasETag)((Object)rsrc)).getETag());
        }
        if (rsrc instanceof RestResource.HasLastModified) {
            res.setDateHeader("Last-Modified", ((RestResource.HasLastModified)((Object)rsrc)).getLastModified().getTime());
        }
    }

    private void checkPreconditions(HttpServletRequest req) throws PreconditionFailedException {
        if ("*".equals(req.getHeader("If-None-Match"))) {
            throw new PreconditionFailedException("Resource already exists");
        }
    }

    private static Type inputType(RestModifyView<RestResource, Object> m) {
        Type inputType = RestApiServlet.extractInputType(m.getClass());
        if (inputType == null) {
            throw new IllegalStateException(String.format("View %s does not correctly implement %s", m.getClass(), RestModifyView.class.getSimpleName()));
        }
        return inputType;
    }

    private static Type extractInputType(Class clazz) {
        Type i;
        for (Type type : clazz.getGenericInterfaces()) {
            if (!(type instanceof ParameterizedType) || ((ParameterizedType)type).getRawType() != RestModifyView.class) continue;
            return ((ParameterizedType)type).getActualTypeArguments()[1];
        }
        if (clazz.getSuperclass() != null && (i = RestApiServlet.extractInputType(clazz.getSuperclass())) != null) {
            return i;
        }
        for (Type type : clazz.getInterfaces()) {
            Type i2 = RestApiServlet.extractInputType((Class)type);
            if (i2 == null) continue;
            return i2;
        }
        return null;
    }

    private Object parseRequest(HttpServletRequest req, Type type) throws IOException, BadRequestException, SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InstantiationException, InvocationTargetException, MethodNotAllowedException {
        if (RestApiServlet.isType(JSON_TYPE, req.getContentType())) {
            Throwable throwable = null;
            try (BufferedReader br = req.getReader();){
                Object t;
                Throwable throwable2;
                JsonReader json2;
                block28: {
                    JsonToken first;
                    json2 = new JsonReader(br);
                    throwable2 = null;
                    json2.setLenient(true);
                    try {
                        first = json2.peek();
                    }
                    catch (EOFException e) {
                        throw new BadRequestException("Expected JSON object");
                    }
                    if (first != JsonToken.STRING) break block28;
                    Object object = this.parseString(json2.nextString(), type);
                    RestApiServlet.$closeResource(throwable2, json2);
                    return object;
                }
                try {
                    t = OutputFormat.JSON.newGson().fromJson(json2, type);
                }
                catch (Throwable first) {
                    try {
                        try {
                            throwable2 = first;
                            throw first;
                        }
                        catch (Throwable throwable3) {
                            RestApiServlet.$closeResource(throwable2, json2);
                            throw throwable3;
                        }
                    }
                    catch (Throwable json2) {
                        throwable = json2;
                        throw json2;
                    }
                }
                RestApiServlet.$closeResource(throwable2, json2);
                return t;
            }
        }
        if (("PUT".equals(req.getMethod()) || "POST".equals(req.getMethod())) && RestApiServlet.acceptsRawInput(type)) {
            return this.parseRawInput(req, type);
        }
        if ("DELETE".equals(req.getMethod()) && RestApiServlet.hasNoBody(req)) {
            return null;
        }
        if (RestApiServlet.hasNoBody(req)) {
            return RestApiServlet.createInstance(type);
        }
        if (RestApiServlet.isType("text/plain", req.getContentType())) {
            try (BufferedReader br = req.getReader();){
                int n;
                char[] tmp = new char[256];
                StringBuilder sb = new StringBuilder();
                while (0 < (n = br.read(tmp))) {
                    sb.append(tmp, 0, n);
                }
                Object object = this.parseString(sb.toString(), type);
                return object;
            }
        }
        if ("POST".equals(req.getMethod()) && RestApiServlet.isType(FORM_TYPE, req.getContentType())) {
            return OutputFormat.JSON.newGson().fromJson((JsonElement)ParameterParser.formToJson(req), type);
        }
        throw new BadRequestException("Expected Content-Type: application/json");
    }

    private static boolean hasNoBody(HttpServletRequest req) {
        int len = req.getContentLength();
        String type = req.getContentType();
        return len <= 0 && type == null || len == 0 && RestApiServlet.isType(FORM_TYPE, type);
    }

    private static boolean acceptsRawInput(Type type) {
        if (type instanceof Class) {
            for (Field f : ((Class)type).getDeclaredFields()) {
                if (f.getType() != RawInput.class) continue;
                return true;
            }
        }
        return false;
    }

    private Object parseRawInput(HttpServletRequest req, Type type) throws SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException, MethodNotAllowedException {
        Object obj = RestApiServlet.createInstance(type);
        for (Field f : obj.getClass().getDeclaredFields()) {
            if (f.getType() != RawInput.class) continue;
            f.setAccessible(true);
            f.set(obj, RawInputUtil.create(req));
            return obj;
        }
        throw new MethodNotAllowedException();
    }

    private Object parseString(String value, Type type) throws BadRequestException, SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (type == String.class) {
            return value;
        }
        Object obj = RestApiServlet.createInstance(type);
        Field[] fields = obj.getClass().getDeclaredFields();
        if (fields.length == 0 && Strings.isNullOrEmpty(value)) {
            return obj;
        }
        for (Field f : fields) {
            if (f.getAnnotation(DefaultInput.class) == null || f.getType() != String.class) continue;
            f.setAccessible(true);
            f.set(obj, value);
            return obj;
        }
        throw new BadRequestException("Expected JSON object");
    }

    private static Object createInstance(Type type) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            Constructor c = clazz.getDeclaredConstructor(new Class[0]);
            c.setAccessible(true);
            return c.newInstance(new Object[0]);
        }
        throw new InstantiationException("Cannot make " + type);
    }

    public static long replyJson(@Nullable HttpServletRequest req, HttpServletResponse res, ListMultimap<String, String> config, Object result) throws IOException {
        TemporaryBuffer.Heap buf = RestApiServlet.heap(81920, Integer.MAX_VALUE);
        buf.write(JSON_MAGIC);
        BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)buf, StandardCharsets.UTF_8));
        Gson gson = RestApiServlet.newGson(config, req);
        if (result instanceof JsonElement) {
            gson.toJson((JsonElement)result, (Appendable)w);
        } else {
            gson.toJson(result, (Appendable)w);
        }
        ((Writer)w).write(10);
        ((Writer)w).flush();
        return RestApiServlet.replyBinaryResult(req, res, RestApiServlet.asBinaryResult(buf).setContentType(JSON_TYPE).setCharacterEncoding(StandardCharsets.UTF_8));
    }

    private static Gson newGson(ListMultimap<String, String> config, @Nullable HttpServletRequest req) {
        GsonBuilder gb = OutputFormat.JSON_COMPACT.newGsonBuilder();
        RestApiServlet.enablePrettyPrint(gb, config, req);
        RestApiServlet.enablePartialGetFields(gb, config);
        return gb.create();
    }

    private static void enablePrettyPrint(GsonBuilder gb, ListMultimap<String, String> config, @Nullable HttpServletRequest req) {
        String pp = Iterables.getFirst(config.get((Object)"pp"), null);
        if (pp == null && (pp = (String)Iterables.getFirst(config.get((Object)"prettyPrint"), null)) == null && req != null) {
            String string = pp = RestApiServlet.acceptsJson(req) ? "0" : "1";
        }
        if ("1".equals(pp) || "true".equals(pp)) {
            gb.setPrettyPrinting();
        }
    }

    private static void enablePartialGetFields(GsonBuilder gb, ListMultimap<String, String> config) {
        final HashSet want = new HashSet();
        for (String p : config.get((Object)"fields")) {
            Iterables.addAll(want, OptionUtil.splitOptionValue(p));
        }
        if (!want.isEmpty()) {
            gb.addSerializationExclusionStrategy(new ExclusionStrategy(){
                private final Map<String, String> names = new HashMap<String, String>();

                @Override
                public boolean shouldSkipField(FieldAttributes field) {
                    String name = this.names.get(field.getName());
                    if (name == null) {
                        try {
                            name = FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES.translateName(field.getDeclaringClass().getDeclaredField(field.getName()));
                            this.names.put(field.getName(), name);
                        }
                        catch (SecurityException e) {
                            return true;
                        }
                        catch (NoSuchFieldException e) {
                            return true;
                        }
                    }
                    return !want.contains(name);
                }

                @Override
                public boolean shouldSkipClass(Class<?> clazz) {
                    return false;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long replyBinaryResult(@Nullable HttpServletRequest req, HttpServletResponse res, BinaryResult bin) throws IOException {
        try (BinaryResult appResult = bin;){
            if (bin.getAttachmentName() != null) {
                res.setHeader("Content-Disposition", "attachment; filename=\"" + bin.getAttachmentName() + "\"");
            }
            if (bin.isBase64()) {
                bin = req != null && JSON_TYPE.equals(req.getHeader("Accept")) ? RestApiServlet.stackJsonString(res, bin) : RestApiServlet.stackBase64(res, bin);
            }
            if (bin.canGzip() && RestApiServlet.acceptsGzip(req)) {
                bin = RestApiServlet.stackGzip(res, bin);
            }
            res.setContentType(bin.getContentType());
            long len = bin.getContentLength();
            if (0L <= len && len < Integer.MAX_VALUE) {
                res.setContentLength((int)len);
            } else if (0L <= len) {
                res.setHeader("Content-Length", Long.toString(len));
            }
            if (req == null || !"HEAD".equals(req.getMethod())) {
                long l;
                CountingOutputStream dst = new CountingOutputStream(res.getOutputStream());
                Throwable throwable = null;
                try {
                    bin.writeTo(dst);
                    l = dst.getCount();
                }
                catch (Throwable throwable2) {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        RestApiServlet.$closeResource(throwable, dst);
                        throw throwable3;
                    }
                }
                RestApiServlet.$closeResource(throwable, dst);
                return l;
            }
            long l = 0L;
            return l;
        }
    }

    private static BinaryResult stackJsonString(HttpServletResponse res, BinaryResult src) throws IOException {
        TemporaryBuffer.Heap buf = RestApiServlet.heap(81920, Integer.MAX_VALUE);
        buf.write(JSON_MAGIC);
        try (BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)buf, StandardCharsets.UTF_8));
             JsonWriter json = new JsonWriter(w);){
            json.setLenient(true);
            json.setHtmlSafe(true);
            json.value(src.asString());
            ((Writer)w).write(10);
        }
        res.setHeader("X-FYI-Content-Encoding", "json");
        res.setHeader("X-FYI-Content-Type", src.getContentType());
        return RestApiServlet.asBinaryResult(buf).setContentType(JSON_TYPE).setCharacterEncoding(StandardCharsets.UTF_8);
    }

    private static BinaryResult stackBase64(HttpServletResponse res, final BinaryResult src) throws IOException {
        long len = src.getContentLength();
        BinaryResult b64 = 0L <= len && len <= 0x700000L ? RestApiServlet.base64(src) : new BinaryResult(){

            @Override
            public void writeTo(OutputStream out) throws IOException {
                try (OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FilterOutputStream(out){

                    @Override
                    public void close() {
                    }
                }, StandardCharsets.ISO_8859_1);
                     OutputStream e = BaseEncoding.base64().encodingStream(w);){
                    src.writeTo(e);
                }
            }
        };
        res.setHeader("X-FYI-Content-Encoding", "base64");
        res.setHeader("X-FYI-Content-Type", src.getContentType());
        return b64.setContentType("text/plain").setCharacterEncoding(StandardCharsets.ISO_8859_1);
    }

    private static BinaryResult stackGzip(HttpServletResponse res, final BinaryResult src) throws IOException {
        BinaryResult gz;
        long len = src.getContentLength();
        if (len < 256L) {
            return src;
        }
        if (len <= 0xA00000L) {
            gz = RestApiServlet.compress(src);
            if (len <= gz.getContentLength()) {
                return src;
            }
        } else {
            gz = new BinaryResult(){

                @Override
                public void writeTo(OutputStream out) throws IOException {
                    GZIPOutputStream gz = new GZIPOutputStream(out);
                    src.writeTo(gz);
                    gz.finish();
                    gz.flush();
                }
            };
        }
        res.setHeader("Content-Encoding", "gzip");
        return gz.setContentType(src.getContentType());
    }

    private ViewData view(RestResource rsrc, RestCollection<RestResource, RestResource> rc, String method, List<IdString> path) throws AmbiguousViewException, RestApiException {
        IdString projection;
        DynamicMap<RestView<RestResource>> views = rc.views();
        IdString idString = projection = path.isEmpty() ? IdString.fromUrl("/") : path.remove(0);
        if (!path.isEmpty()) {
            method = "GET";
        } else if ("HEAD".equals(method)) {
            method = "GET";
        }
        List<String> p = RestApiServlet.splitProjection(projection);
        if (p.size() == 2) {
            RestView<RestResource> view;
            String viewname = p.get(1);
            if (Strings.isNullOrEmpty(viewname)) {
                viewname = "/";
            }
            if ((view = views.get(p.get(0), method + "." + viewname)) != null) {
                return new ViewData(p.get(0), view);
            }
            view = views.get(p.get(0), "GET." + viewname);
            if (view != null && view instanceof AcceptsPost && "POST".equals(method)) {
                AcceptsPost ap = (AcceptsPost)((Object)view);
                return new ViewData(p.get(0), ap.post(rsrc));
            }
            throw new ResourceNotFoundException(projection);
        }
        String name = method + "." + p.get(0);
        RestView<RestResource> core = views.get("gerrit", name);
        if (core != null) {
            return new ViewData(null, core);
        }
        core = views.get("gerrit", "GET." + p.get(0));
        if (core instanceof AcceptsPost && "POST".equals(method)) {
            AcceptsPost ap = (AcceptsPost)((Object)core);
            return new ViewData(null, ap.post(rsrc));
        }
        TreeMap<String, RestView<RestResource>> r = new TreeMap<String, RestView<RestResource>>();
        for (String plugin : views.plugins()) {
            RestView<RestResource> action = views.get(plugin, name);
            if (action == null) continue;
            r.put(plugin, action);
        }
        if (r.size() == 1) {
            Map.Entry entry = Iterables.getOnlyElement(r.entrySet());
            return new ViewData((String)entry.getKey(), (RestView)entry.getValue());
        }
        if (r.isEmpty()) {
            throw new ResourceNotFoundException(projection);
        }
        throw new AmbiguousViewException(String.format("Projection %s is ambiguous: %s", name, r.keySet().stream().map(in -> in + "~" + projection).collect(Collectors.joining(", "))));
    }

    private static List<IdString> splitPath(HttpServletRequest req) {
        String path = RequestUtil.getEncodedPathInfo(req);
        if (Strings.isNullOrEmpty(path)) {
            return Collections.emptyList();
        }
        ArrayList<IdString> out = new ArrayList<IdString>();
        for (String p : Splitter.on('/').split(path)) {
            out.add(IdString.fromUrl(p));
        }
        if (out.size() > 0 && ((IdString)out.get(out.size() - 1)).isEmpty()) {
            out.remove(out.size() - 1);
        }
        return out;
    }

    private static List<String> splitProjection(IdString projection) {
        ArrayList<String> p = Lists.newArrayListWithCapacity(2);
        Iterables.addAll(p, Splitter.on('~').limit(2).split(projection.get()));
        return p;
    }

    private void checkUserSession(HttpServletRequest req) throws AuthException {
        CurrentUser user = this.globals.currentUser.get();
        if (RestApiServlet.isRead(req)) {
            user.setAccessPath(AccessPath.REST_API);
            user.setLastLoginExternalIdKey(this.globals.webSession.get().getLastLoginExternalId());
        } else {
            if (user instanceof AnonymousUser) {
                throw new AuthException("Authentication required");
            }
            if (!this.globals.webSession.get().isAccessPathOk(AccessPath.REST_API)) {
                throw new AuthException("Invalid authentication method. In order to authenticate, prefix the REST endpoint URL with /a/ (e.g. http://example.com/a/projects/).");
            }
        }
    }

    private static boolean isRead(HttpServletRequest req) {
        return "GET".equals(req.getMethod()) || "HEAD".equals(req.getMethod());
    }

    private void checkRequiresCapability(ViewData viewData) throws AuthException {
        CapabilityUtils.checkRequiresCapability(this.globals.currentUser, viewData.pluginName, viewData.view.getClass());
    }

    private static long handleException(Throwable err, HttpServletRequest req, HttpServletResponse res) throws IOException {
        String uri = req.getRequestURI();
        if (!Strings.isNullOrEmpty(req.getQueryString())) {
            uri = uri + "?" + req.getQueryString();
        }
        log.error("Error in {} {}", req.getMethod(), uri, err);
        if (!res.isCommitted()) {
            res.reset();
            return RestApiServlet.replyError(req, res, 500, "Internal server error", err);
        }
        return 0L;
    }

    public static long replyError(HttpServletRequest req, HttpServletResponse res, int statusCode, String msg, @Nullable Throwable err) throws IOException {
        return RestApiServlet.replyError(req, res, statusCode, msg, CacheControl.NONE, err);
    }

    public static long replyError(HttpServletRequest req, HttpServletResponse res, int statusCode, String msg, CacheControl c, @Nullable Throwable err) throws IOException {
        if (err != null) {
            RequestUtil.setErrorTraceAttribute(req, err);
        }
        RestApiServlet.configureCaching(req, res, null, null, c);
        res.setStatus(statusCode);
        return RestApiServlet.replyText(req, res, msg);
    }

    static long replyText(@Nullable HttpServletRequest req, HttpServletResponse res, String text) throws IOException {
        if ((req == null || RestApiServlet.isRead(req)) && RestApiServlet.isMaybeHTML(text)) {
            return RestApiServlet.replyJson(req, res, ImmutableListMultimap.of("pp", "0"), new JsonPrimitive(text));
        }
        if (!text.endsWith("\n")) {
            text = text + "\n";
        }
        return RestApiServlet.replyBinaryResult(req, res, BinaryResult.create(text).setContentType("text/plain"));
    }

    private static boolean isMaybeHTML(String text) {
        return CharMatcher.anyOf("<&").matchesAnyOf(text);
    }

    private static boolean acceptsJson(HttpServletRequest req) {
        return req != null && RestApiServlet.isType(JSON_TYPE, req.getHeader("Accept"));
    }

    private static boolean acceptsGzip(HttpServletRequest req) {
        if (req != null) {
            String accepts = req.getHeader("Accept-Encoding");
            return accepts != null && accepts.contains("gzip");
        }
        return false;
    }

    private static boolean isType(String expect, String given) {
        if (given == null) {
            return false;
        }
        if (expect.equals(given)) {
            return true;
        }
        if (given.startsWith(expect + ",")) {
            return true;
        }
        for (String p : given.split("[ ,;][ ,;]*")) {
            if (!expect.equals(p)) continue;
            return true;
        }
        return false;
    }

    private static int base64MaxSize(long n) {
        return 4 * IntMath.divide((int)n, 3, RoundingMode.CEILING);
    }

    private static BinaryResult base64(BinaryResult bin) throws IOException {
        int maxSize = RestApiServlet.base64MaxSize(bin.getContentLength());
        int estSize = Math.min(RestApiServlet.base64MaxSize(81920L), maxSize);
        TemporaryBuffer.Heap buf = RestApiServlet.heap(estSize, maxSize);
        try (OutputStream encoded = BaseEncoding.base64().encodingStream(new OutputStreamWriter((OutputStream)buf, StandardCharsets.ISO_8859_1));){
            bin.writeTo(encoded);
        }
        return RestApiServlet.asBinaryResult(buf);
    }

    private static BinaryResult compress(BinaryResult bin) throws IOException {
        TemporaryBuffer.Heap buf = RestApiServlet.heap(81920, 0x1400000);
        try (GZIPOutputStream gz = new GZIPOutputStream(buf);){
            bin.writeTo(gz);
        }
        return RestApiServlet.asBinaryResult(buf).setContentType(bin.getContentType());
    }

    private static BinaryResult asBinaryResult(final TemporaryBuffer.Heap buf) {
        return new BinaryResult(){

            @Override
            public void writeTo(OutputStream os) throws IOException {
                buf.writeTo(os, null);
            }
        }.setContentLength(buf.length());
    }

    private static TemporaryBuffer.Heap heap(int est, int max) {
        return new TemporaryBuffer.Heap(est, max);
    }

    static class ViewData {
        String pluginName;
        RestView<RestResource> view;

        ViewData(String pluginName, RestView<RestResource> view) {
            this.pluginName = pluginName;
            this.view = view;
        }
    }

    private static class AmbiguousViewException
    extends Exception {
        AmbiguousViewException(String message) {
            super(message);
        }
    }

    public static class Globals {
        final Provider<CurrentUser> currentUser;
        final DynamicItem<WebSession> webSession;
        final Provider<ParameterParser> paramParser;
        final AuditService auditService;
        final RestApiMetrics metrics;
        final Pattern allowOrigin;

        @Inject
        Globals(Provider<CurrentUser> currentUser, DynamicItem<WebSession> webSession, Provider<ParameterParser> paramParser, AuditService auditService, RestApiMetrics metrics, @GerritServerConfig Config cfg) {
            this.currentUser = currentUser;
            this.webSession = webSession;
            this.paramParser = paramParser;
            this.auditService = auditService;
            this.metrics = metrics;
            this.allowOrigin = Globals.makeAllowOrigin(cfg);
        }

        private static Pattern makeAllowOrigin(Config cfg) {
            Object[] allow = cfg.getStringList("site", null, "allowOriginRegex");
            if (allow.length > 0) {
                return Pattern.compile(Joiner.on('|').join(allow));
            }
            return null;
        }
    }
}

