/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.reviewdb.client;

import com.google.gerrit.extensions.client.InheritableBoolean;
import com.google.gerrit.extensions.client.ProjectState;
import com.google.gerrit.extensions.client.SubmitType;
import com.google.gwtorm.client.Column;
import com.google.gwtorm.client.Key;
import com.google.gwtorm.client.StringKey;

public final class Project {
    protected NameKey name;
    protected String description;
    protected InheritableBoolean useContributorAgreements;
    protected InheritableBoolean useSignedOffBy;
    protected SubmitType submitType;
    protected ProjectState state;
    protected NameKey parent;
    protected InheritableBoolean requireChangeID;
    protected String maxObjectSizeLimit;
    protected InheritableBoolean useContentMerge;
    protected String defaultDashboardId;
    protected String localDefaultDashboardId;
    protected String themeName;
    protected InheritableBoolean createNewChangeForAllNotInTarget;
    protected InheritableBoolean enableSignedPush;
    protected InheritableBoolean requireSignedPush;
    protected InheritableBoolean rejectImplicitMerges;

    protected Project() {
    }

    public Project(NameKey nameKey) {
        this.name = nameKey;
        this.submitType = SubmitType.MERGE_IF_NECESSARY;
        this.state = ProjectState.ACTIVE;
        this.useContributorAgreements = InheritableBoolean.INHERIT;
        this.useSignedOffBy = InheritableBoolean.INHERIT;
        this.requireChangeID = InheritableBoolean.INHERIT;
        this.useContentMerge = InheritableBoolean.INHERIT;
        this.createNewChangeForAllNotInTarget = InheritableBoolean.INHERIT;
        this.enableSignedPush = InheritableBoolean.INHERIT;
        this.requireSignedPush = InheritableBoolean.INHERIT;
    }

    public NameKey getNameKey() {
        return this.name;
    }

    public String getName() {
        return this.name != null ? this.name.get() : null;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String d) {
        this.description = d;
    }

    public InheritableBoolean getUseContributorAgreements() {
        return this.useContributorAgreements;
    }

    public InheritableBoolean getUseSignedOffBy() {
        return this.useSignedOffBy;
    }

    public InheritableBoolean getUseContentMerge() {
        return this.useContentMerge;
    }

    public InheritableBoolean getRequireChangeID() {
        return this.requireChangeID;
    }

    public String getMaxObjectSizeLimit() {
        return this.maxObjectSizeLimit;
    }

    public InheritableBoolean getRejectImplicitMerges() {
        return this.rejectImplicitMerges;
    }

    public void setUseContributorAgreements(InheritableBoolean u) {
        this.useContributorAgreements = u;
    }

    public void setUseSignedOffBy(InheritableBoolean sbo) {
        this.useSignedOffBy = sbo;
    }

    public void setUseContentMerge(InheritableBoolean cm) {
        this.useContentMerge = cm;
    }

    public void setRequireChangeID(InheritableBoolean cid) {
        this.requireChangeID = cid;
    }

    public InheritableBoolean getCreateNewChangeForAllNotInTarget() {
        return this.createNewChangeForAllNotInTarget;
    }

    public void setCreateNewChangeForAllNotInTarget(InheritableBoolean useAllNotInTarget) {
        this.createNewChangeForAllNotInTarget = useAllNotInTarget;
    }

    public InheritableBoolean getEnableSignedPush() {
        return this.enableSignedPush;
    }

    public void setEnableSignedPush(InheritableBoolean enable) {
        this.enableSignedPush = enable;
    }

    public InheritableBoolean getRequireSignedPush() {
        return this.requireSignedPush;
    }

    public void setRequireSignedPush(InheritableBoolean require) {
        this.requireSignedPush = require;
    }

    public void setMaxObjectSizeLimit(String limit) {
        this.maxObjectSizeLimit = limit;
    }

    public void setRejectImplicitMerges(InheritableBoolean check) {
        this.rejectImplicitMerges = check;
    }

    public SubmitType getSubmitType() {
        return this.submitType;
    }

    public void setSubmitType(SubmitType type) {
        this.submitType = type;
    }

    public ProjectState getState() {
        return this.state;
    }

    public void setState(ProjectState newState) {
        this.state = newState;
    }

    public String getDefaultDashboard() {
        return this.defaultDashboardId;
    }

    public void setDefaultDashboard(String defaultDashboardId) {
        this.defaultDashboardId = defaultDashboardId;
    }

    public String getLocalDefaultDashboard() {
        return this.localDefaultDashboardId;
    }

    public void setLocalDefaultDashboard(String localDefaultDashboardId) {
        this.localDefaultDashboardId = localDefaultDashboardId;
    }

    public String getThemeName() {
        return this.themeName;
    }

    public void setThemeName(String themeName) {
        this.themeName = themeName;
    }

    public void copySettingsFrom(Project update) {
        this.description = update.description;
        this.useContributorAgreements = update.useContributorAgreements;
        this.useSignedOffBy = update.useSignedOffBy;
        this.useContentMerge = update.useContentMerge;
        this.requireChangeID = update.requireChangeID;
        this.submitType = update.submitType;
        this.state = update.state;
        this.maxObjectSizeLimit = update.maxObjectSizeLimit;
        this.createNewChangeForAllNotInTarget = update.createNewChangeForAllNotInTarget;
    }

    public NameKey getParent() {
        return this.parent;
    }

    public NameKey getParent(NameKey allProjectsName) {
        if (this.parent != null) {
            return this.parent;
        }
        if (this.name.equals(allProjectsName)) {
            return null;
        }
        return allProjectsName;
    }

    public String getParentName() {
        return this.parent != null ? this.parent.get() : null;
    }

    public void setParentName(String n) {
        this.parent = n != null ? new NameKey(n) : null;
    }

    public void setParentName(NameKey n) {
        this.parent = n;
    }

    public static class NameKey
    extends StringKey<Key<?>> {
        private static final long serialVersionUID = 1L;
        @Column(id=1)
        protected String name;

        protected NameKey() {
        }

        public NameKey(String n) {
            this.name = n;
        }

        @Override
        public String get() {
            return this.name;
        }

        @Override
        protected void set(String newValue) {
            this.name = newValue;
        }

        @Override
        public int hashCode() {
            return this.get().hashCode();
        }

        @Override
        public boolean equals(Object b) {
            if (b instanceof NameKey) {
                return this.get().equals(((NameKey)b).get());
            }
            return false;
        }

        public static NameKey parse(String str) {
            NameKey r = new NameKey();
            r.fromString(str);
            return r;
        }
    }
}

