/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.account.AccountByEmailCache;
import com.google.gerrit.server.account.AccountState;
import com.google.gerrit.server.cache.CacheModule;
import com.google.gerrit.server.query.account.InternalAccountQuery;
import com.google.gwtorm.server.SchemaFactory;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Named;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AccountByEmailCacheImpl
implements AccountByEmailCache {
    private static final Logger log = LoggerFactory.getLogger(AccountByEmailCacheImpl.class);
    private static final String CACHE_NAME = "accounts_byemail";
    private final LoadingCache<String, Set<Account.Id>> cache;

    public static Module module() {
        return new CacheModule(){

            @Override
            protected void configure() {
                this.cache(AccountByEmailCacheImpl.CACHE_NAME, String.class, new TypeLiteral<Set<Account.Id>>(){}).loader(Loader.class);
                this.bind(AccountByEmailCacheImpl.class);
                this.bind(AccountByEmailCache.class).to(AccountByEmailCacheImpl.class);
            }
        };
    }

    @Inject
    AccountByEmailCacheImpl(@Named(value="accounts_byemail") LoadingCache<String, Set<Account.Id>> cache) {
        this.cache = cache;
    }

    @Override
    public Set<Account.Id> get(String email) {
        try {
            return this.cache.get(email);
        }
        catch (ExecutionException e) {
            log.warn("Cannot resolve accounts by email", e);
            return Collections.emptySet();
        }
    }

    @Override
    public void evict(String email) {
        if (email != null) {
            this.cache.invalidate(email);
        }
    }

    static class Loader
    extends CacheLoader<String, Set<Account.Id>> {
        private final SchemaFactory<ReviewDb> schema;
        private final Provider<InternalAccountQuery> accountQueryProvider;

        @Inject
        Loader(SchemaFactory<ReviewDb> schema, Provider<InternalAccountQuery> accountQueryProvider) {
            this.schema = schema;
            this.accountQueryProvider = accountQueryProvider;
        }

        @Override
        public Set<Account.Id> load(String email) throws Exception {
            try (ReviewDb db = this.schema.open();){
                HashSet<Account.Id> r = new HashSet<Account.Id>();
                for (Account a : db.accounts().byPreferredEmail(email)) {
                    r.add(a.getId());
                }
                for (AccountState accountState : this.accountQueryProvider.get().byEmailPrefix(email)) {
                    if (!accountState.getExternalIds().stream().filter(e -> email.equals(e.email())).findAny().isPresent()) continue;
                    r.add(accountState.getAccount().getId());
                }
                ImmutableSet immutableSet = ImmutableSet.copyOf(r);
                return immutableSet;
            }
        }
    }
}

