/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.gerrit.extensions.client.AccountFieldName;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.MethodNotAllowedException;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.AccountException;
import com.google.gerrit.server.account.AccountManager;
import com.google.gerrit.server.account.AccountResource;
import com.google.gerrit.server.account.AuthRequest;
import com.google.gerrit.server.account.ExternalId;
import com.google.gerrit.server.account.Realm;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jgit.errors.ConfigInvalidException;

@Singleton
public class DeleteEmail
implements RestModifyView<AccountResource.Email, Input> {
    private final Provider<CurrentUser> self;
    private final Realm realm;
    private final Provider<ReviewDb> dbProvider;
    private final AccountManager accountManager;

    @Inject
    DeleteEmail(Provider<CurrentUser> self, Realm realm, Provider<ReviewDb> dbProvider, AccountManager accountManager) {
        this.self = self;
        this.realm = realm;
        this.dbProvider = dbProvider;
        this.accountManager = accountManager;
    }

    public Response<?> apply(AccountResource.Email rsrc, Input input) throws AuthException, ResourceNotFoundException, ResourceConflictException, MethodNotAllowedException, OrmException, IOException, ConfigInvalidException {
        if (!this.self.get().hasSameAccountId(rsrc.getUser()) && !this.self.get().getCapabilities().canModifyAccount()) {
            throw new AuthException("not allowed to delete email address");
        }
        return this.apply(rsrc.getUser(), rsrc.getEmail());
    }

    public Response<?> apply(IdentifiedUser user, String email) throws ResourceNotFoundException, ResourceConflictException, MethodNotAllowedException, OrmException, IOException {
        if (!this.realm.allowsEdit(AccountFieldName.REGISTER_NEW_EMAIL)) {
            throw new MethodNotAllowedException("realm does not allow deleting emails");
        }
        Set extIds = this.dbProvider.get().accountExternalIds().byAccount(user.getAccountId()).toList().stream().map(ExternalId::from).filter(e -> email.equals(e.email())).collect(Collectors.toSet());
        if (extIds.isEmpty()) {
            throw new ResourceNotFoundException(email);
        }
        try {
            for (ExternalId extId : extIds) {
                AuthRequest authRequest = new AuthRequest(extId.key());
                authRequest.setEmailAddress(email);
                this.accountManager.unlink(user.getAccountId(), authRequest);
            }
        }
        catch (AccountException e2) {
            throw new ResourceConflictException(e2.getMessage());
        }
        return Response.none();
    }

    public static class Input {
    }
}

