/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.gerrit.extensions.client.GeneralPreferencesInfo;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.account.AccountCache;
import com.google.gerrit.server.account.AccountResource;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;

@Singleton
public class GetPreferences
implements RestReadView<AccountResource> {
    private final Provider<CurrentUser> self;
    private final AccountCache accountCache;

    @Inject
    GetPreferences(Provider<CurrentUser> self, AccountCache accountCache) {
        this.self = self;
        this.accountCache = accountCache;
    }

    public GeneralPreferencesInfo apply(AccountResource rsrc) throws AuthException {
        if (!this.self.get().hasSameAccountId(rsrc.getUser()) && !this.self.get().getCapabilities().canModifyAccount()) {
            throw new AuthException("requires Modify Account capability");
        }
        Account.Id id = rsrc.getUser().getAccountId();
        return this.accountCache.get(id).getAccount().getGeneralPreferencesInfo();
    }
}

