/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.InternalUser;
import com.google.gerrit.server.change.Abandon;
import com.google.gerrit.server.config.ChangeCleanupConfig;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gerrit.server.query.QueryParseException;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.ChangeQueryBuilder;
import com.google.gerrit.server.query.change.ChangeQueryProcessor;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AbandonUtil {
    private static final Logger log = LoggerFactory.getLogger(AbandonUtil.class);
    private final ChangeCleanupConfig cfg;
    private final ChangeQueryProcessor queryProcessor;
    private final ChangeQueryBuilder queryBuilder;
    private final Abandon abandon;
    private final InternalUser internalUser;

    @Inject
    AbandonUtil(ChangeCleanupConfig cfg, InternalUser.Factory internalUserFactory, ChangeQueryProcessor queryProcessor, ChangeQueryBuilder queryBuilder, Abandon abandon) {
        this.cfg = cfg;
        this.queryProcessor = queryProcessor;
        this.queryBuilder = queryBuilder;
        this.abandon = abandon;
        this.internalUser = internalUserFactory.create();
    }

    public void abandonInactiveOpenChanges() {
        if (this.cfg.getAbandonAfter() <= 0L) {
            return;
        }
        try {
            String query = "status:new age:" + TimeUnit.MILLISECONDS.toMinutes(this.cfg.getAbandonAfter()) + "m";
            if (!this.cfg.getAbandonIfMergeable()) {
                query = query + " -is:mergeable";
            }
            List changesToAbandon = this.queryProcessor.enforceVisibility(false).query(this.queryBuilder.parse(query)).entities();
            ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
            for (ChangeData cd : changesToAbandon) {
                ChangeControl control = cd.changeControl(this.internalUser);
                builder.put(control.getProject().getNameKey(), control);
            }
            int count = 0;
            ImmutableMultimap abandons = builder.build();
            String message = this.cfg.getAbandonMessage();
            for (Project.NameKey project : abandons.keySet()) {
                Collection<ChangeControl> changes = this.getValidChanges(abandons.get(project), query);
                try {
                    this.abandon.batchAbandon(project, this.internalUser, changes, message);
                    count += changes.size();
                }
                catch (Throwable e) {
                    StringBuilder msg = new StringBuilder("Failed to auto-abandon inactive change(s):");
                    for (ChangeControl change : changes) {
                        msg.append(" ").append(change.getId().get());
                    }
                    msg.append(".");
                    log.error(msg.toString(), e);
                }
            }
            log.info("Auto-Abandoned {} of {} changes.", (Object)count, (Object)changesToAbandon.size());
        }
        catch (QueryParseException | OrmException e) {
            log.error("Failed to query inactive open changes for auto-abandoning.", e);
        }
    }

    private Collection<ChangeControl> getValidChanges(Collection<ChangeControl> changeControls, String query) throws OrmException, QueryParseException {
        ArrayList<ChangeControl> validChanges = new ArrayList<ChangeControl>();
        for (ChangeControl cc : changeControls) {
            String newQuery = query + " change:" + cc.getId();
            List changesToAbandon = this.queryProcessor.enforceVisibility(false).query(this.queryBuilder.parse(newQuery)).entities();
            if (!changesToAbandon.isEmpty()) {
                validChanges.add(cc);
                continue;
            }
            log.debug("Change data with id \"{}\" does not satisfy the query \"{}\" any more, hence skipping it in clean up", (Object)cc.getId(), (Object)query);
        }
        return validChanges;
    }
}

