/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.Weigher;
import com.google.common.collect.FluentIterable;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.extensions.client.ChangeKind;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.cache.CacheModule;
import com.google.gerrit.server.change.ChangeKindCache;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.MergeUtil;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.name.Named;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdSerialization;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeKindCacheImpl
implements ChangeKindCache {
    private static final Logger log = LoggerFactory.getLogger(ChangeKindCacheImpl.class);
    private static final String ID_CACHE = "change_kind";
    private final Cache<Key, ChangeKind> cache;
    private final boolean useRecursiveMerge;
    private final ChangeData.Factory changeDataFactory;
    private final GitRepositoryManager repoManager;

    public static Module module() {
        return new CacheModule(){

            @Override
            protected void configure() {
                this.bind(ChangeKindCache.class).to(ChangeKindCacheImpl.class);
                this.persist(ChangeKindCacheImpl.ID_CACHE, Key.class, ChangeKind.class).maximumWeight(0x200000L).weigher(ChangeKindWeigher.class);
            }
        };
    }

    @Inject
    ChangeKindCacheImpl(@GerritServerConfig Config serverConfig, @Named(value="change_kind") Cache<Key, ChangeKind> cache, ChangeData.Factory changeDataFactory, GitRepositoryManager repoManager) {
        this.cache = cache;
        this.useRecursiveMerge = MergeUtil.useRecursiveMerge(serverConfig);
        this.changeDataFactory = changeDataFactory;
        this.repoManager = repoManager;
    }

    @Override
    public ChangeKind getChangeKind(Project.NameKey project, @Nullable Repository repo, ObjectId prior, ObjectId next) {
        try {
            Key key = new Key(prior, next, this.useRecursiveMerge);
            return this.cache.get(key, new Loader(key, this.repoManager, project, repo));
        }
        catch (ExecutionException e) {
            log.warn("Cannot check trivial rebase of new patch set " + next.name() + " in " + project, e);
            return ChangeKind.REWORK;
        }
    }

    @Override
    public ChangeKind getChangeKind(ReviewDb db, Change change, PatchSet patch) {
        return ChangeKindCacheImpl.getChangeKindInternal(this, db, change, patch, this.changeDataFactory, this.repoManager);
    }

    @Override
    public ChangeKind getChangeKind(@Nullable Repository repo, ChangeData cd, PatchSet patch) {
        return ChangeKindCacheImpl.getChangeKindInternal(this, repo, cd, patch);
    }

    private static ChangeKind getChangeKindInternal(ChangeKindCache cache, @Nullable Repository repo, ChangeData change, PatchSet patch) {
        ChangeKind kind = ChangeKind.REWORK;
        if (patch.getId().get() > 1) {
            try {
                Collection<PatchSet> patchSetCollection = change.patchSets();
                PatchSet priorPs = patch;
                for (PatchSet ps : patchSetCollection) {
                    if (ps.getId().get() >= patch.getId().get() || ps.getId().get() <= priorPs.getId().get() && priorPs != patch) continue;
                    priorPs = ps;
                }
                if (priorPs != patch) {
                    kind = cache.getChangeKind(change.project(), repo, ObjectId.fromString(priorPs.getRevision().get()), ObjectId.fromString(patch.getRevision().get()));
                }
            }
            catch (OrmException e) {
                log.warn("Unable to get change kind for patchSet " + patch.getPatchSetId() + "of change " + change.getId(), e);
            }
        }
        return kind;
    }

    private static ChangeKind getChangeKindInternal(ChangeKindCache cache, ReviewDb db, Change change, PatchSet patch, ChangeData.Factory changeDataFactory, GitRepositoryManager repoManager) {
        ChangeKind kind = ChangeKind.REWORK;
        if (patch.getId().get() > 1) {
            try (Repository repo = repoManager.openRepository(change.getProject());){
                kind = ChangeKindCacheImpl.getChangeKindInternal(cache, repo, changeDataFactory.create(db, change), patch);
            }
            catch (IOException e) {
                log.warn("Unable to get change kind for patchSet " + patch.getPatchSetId() + "of change " + change.getChangeId(), e);
            }
        }
        return kind;
    }

    public static class ChangeKindWeigher
    implements Weigher<Key, ChangeKind> {
        @Override
        public int weigh(Key key, ChangeKind changeKind) {
            return 88 + 2 * key.strategyName.length() + 2 * changeKind.name().length();
        }
    }

    private static class Loader
    implements Callable<ChangeKind> {
        private final Key key;
        private final GitRepositoryManager repoManager;
        private final Project.NameKey projectName;
        private final Repository alreadyOpenRepo;

        private Loader(Key key, GitRepositoryManager repoManager, Project.NameKey projectName, @Nullable Repository alreadyOpenRepo) {
            this.key = key;
            this.repoManager = repoManager;
            this.projectName = projectName;
            this.alreadyOpenRepo = alreadyOpenRepo;
        }

        /*
         * Exception decompiling
         */
        @Override
        public ChangeKind call() throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public static boolean onlyFirstParentChanged(RevCommit prior, RevCommit next) {
            return !Loader.sameFirstParents(prior, next) && Loader.sameRestOfParents(prior, next);
        }

        private static boolean sameFirstParents(RevCommit prior, RevCommit next) {
            if (prior.getParentCount() == 0) {
                return next.getParentCount() == 0;
            }
            return prior.getParent(0).equals(next.getParent(0));
        }

        private static boolean sameRestOfParents(RevCommit prior, RevCommit next) {
            Set<RevCommit> priorRestParents = Loader.allExceptFirstParent(prior.getParents());
            Set<RevCommit> nextRestParents = Loader.allExceptFirstParent(next.getParents());
            return priorRestParents.equals(nextRestParents);
        }

        private static Set<RevCommit> allExceptFirstParent(RevCommit[] parents) {
            return FluentIterable.from(Arrays.asList(parents)).skip(1).toSet();
        }

        private static boolean isSameDeltaAndTree(RevCommit prior, RevCommit next) {
            if (next.getTree() != prior.getTree()) {
                return false;
            }
            if (prior.getParentCount() != next.getParentCount()) {
                return false;
            }
            if (prior.getParentCount() == 0) {
                return true;
            }
            for (int i = 0; i < prior.getParentCount(); ++i) {
                if (next.getParent(i).getTree() == prior.getParent(i).getTree()) continue;
                return false;
            }
            return true;
        }

        private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
            if (x0 != null) {
                try {
                    x1.close();
                }
                catch (Throwable throwable) {
                    x0.addSuppressed(throwable);
                }
            } else {
                x1.close();
            }
        }
    }

    public static class Key
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private transient ObjectId prior;
        private transient ObjectId next;
        private transient String strategyName;

        private Key(ObjectId prior, ObjectId next, boolean useRecursiveMerge) {
            Preconditions.checkNotNull(next, "next");
            String strategyName = MergeUtil.mergeStrategyName(true, useRecursiveMerge);
            this.prior = prior.copy();
            this.next = next.copy();
            this.strategyName = strategyName;
        }

        public Key(ObjectId prior, ObjectId next, String strategyName) {
            this.prior = prior;
            this.next = next;
            this.strategyName = strategyName;
        }

        public ObjectId getPrior() {
            return this.prior;
        }

        public ObjectId getNext() {
            return this.next;
        }

        public String getStrategyName() {
            return this.strategyName;
        }

        public boolean equals(Object o) {
            if (o instanceof Key) {
                Key k = (Key)o;
                return Objects.equals(this.prior, k.prior) && Objects.equals(this.next, k.next) && Objects.equals(this.strategyName, k.strategyName);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.prior, this.next, this.strategyName);
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            ObjectIdSerialization.writeNotNull(out, this.prior);
            ObjectIdSerialization.writeNotNull(out, this.next);
            out.writeUTF(this.strategyName);
        }

        private void readObject(ObjectInputStream in) throws IOException {
            this.prior = ObjectIdSerialization.readNotNull(in);
            this.next = ObjectIdSerialization.readNotNull(in);
            this.strategyName = in.readUTF();
        }

        static /* synthetic */ ObjectId access$500(Key x0) {
            return x0.prior;
        }

        static /* synthetic */ ObjectId access$600(Key x0) {
            return x0.next;
        }
    }

    @VisibleForTesting
    public static class NoCache
    implements ChangeKindCache {
        private final boolean useRecursiveMerge;
        private final ChangeData.Factory changeDataFactory;
        private final GitRepositoryManager repoManager;

        @Inject
        NoCache(@GerritServerConfig Config serverConfig, ChangeData.Factory changeDataFactory, GitRepositoryManager repoManager) {
            this.useRecursiveMerge = MergeUtil.useRecursiveMerge(serverConfig);
            this.changeDataFactory = changeDataFactory;
            this.repoManager = repoManager;
        }

        @Override
        public ChangeKind getChangeKind(Project.NameKey project, @Nullable Repository repo, ObjectId prior, ObjectId next) {
            try {
                Key key = new Key(prior, next, this.useRecursiveMerge);
                return new Loader(key, this.repoManager, project, repo).call();
            }
            catch (IOException e) {
                log.warn("Cannot check trivial rebase of new patch set " + next.name() + " in " + project, e);
                return ChangeKind.REWORK;
            }
        }

        @Override
        public ChangeKind getChangeKind(ReviewDb db, Change change, PatchSet patch) {
            return ChangeKindCacheImpl.getChangeKindInternal(this, db, change, patch, this.changeDataFactory, this.repoManager);
        }

        @Override
        public ChangeKind getChangeKind(@Nullable Repository repo, ChangeData cd, PatchSet patch) {
            return ChangeKindCacheImpl.getChangeKindInternal(this, repo, cd, patch);
        }
    }
}

