/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.base.MoreObjects;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.gerrit.extensions.restapi.RestResource;
import com.google.gerrit.extensions.restapi.RestView;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.StarredChangesUtil;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gerrit.server.project.ProjectState;
import com.google.gwtorm.server.OrmException;
import com.google.inject.TypeLiteral;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.nio.charset.StandardCharsets;
import org.eclipse.jgit.lib.ObjectId;

public class ChangeResource
implements RestResource,
RestResource.HasETag {
    public static final int JSON_FORMAT_VERSION = 1;
    public static final TypeLiteral<RestView<ChangeResource>> CHANGE_KIND = new TypeLiteral<RestView<ChangeResource>>(){};
    private final StarredChangesUtil starredChangesUtil;
    private final ChangeControl control;

    @AssistedInject
    ChangeResource(StarredChangesUtil starredChangesUtil, @Assisted ChangeControl control) {
        this.starredChangesUtil = starredChangesUtil;
        this.control = control;
    }

    public ChangeControl getControl() {
        return this.control;
    }

    public IdentifiedUser getUser() {
        return this.getControl().getUser().asIdentifiedUser();
    }

    public Change.Id getId() {
        return this.getControl().getId();
    }

    public Change getChange() {
        return this.getControl().getChange();
    }

    public Project.NameKey getProject() {
        return this.getChange().getProject();
    }

    public ChangeNotes getNotes() {
        return this.getControl().getNotes();
    }

    public void prepareETag(Hasher h, CurrentUser user) {
        ObjectId noteId;
        h.putInt(1).putLong(this.getChange().getLastUpdatedOn().getTime()).putInt(this.getChange().getRowVersion()).putInt(user.isIdentifiedUser() ? user.getAccountId().get() : 0);
        if (user.isIdentifiedUser()) {
            for (AccountGroup.UUID uuid : user.getEffectiveGroups().getKnownGroups()) {
                h.putBytes(uuid.get().getBytes(StandardCharsets.UTF_8));
            }
        }
        byte[] buf = new byte[20];
        try {
            noteId = this.getNotes().loadRevision();
        }
        catch (OrmException e) {
            noteId = null;
        }
        this.hashObjectId(h, noteId, buf);
        for (ProjectState p : this.control.getProjectControl().getProjectState().tree()) {
            this.hashObjectId(h, p.getConfig().getRevision(), buf);
        }
    }

    @Override
    public String getETag() {
        CurrentUser user = this.control.getUser();
        Hasher h = Hashing.md5().newHasher();
        if (user.isIdentifiedUser()) {
            h.putString(this.starredChangesUtil.getObjectId(user.getAccountId(), this.getId()).name(), StandardCharsets.UTF_8);
        }
        this.prepareETag(h, user);
        return h.hash().toString();
    }

    private void hashObjectId(Hasher h, ObjectId id, byte[] buf) {
        MoreObjects.firstNonNull(id, ObjectId.zeroId()).copyRawTo(buf, 0);
        h.putBytes(buf);
    }

    public static interface Factory {
        public ChangeResource create(ChangeControl var1);
    }
}

