/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.ChildCollection;
import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestView;
import com.google.gerrit.extensions.restapi.TopLevelResource;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.ApprovalsUtil;
import com.google.gerrit.server.account.AccountsCollection;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.change.ListReviewers;
import com.google.gerrit.server.change.ReviewerResource;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.Collection;

@Singleton
public class Reviewers
implements ChildCollection<ChangeResource, ReviewerResource> {
    private final DynamicMap<RestView<ReviewerResource>> views;
    private final Provider<ReviewDb> dbProvider;
    private final ApprovalsUtil approvalsUtil;
    private final AccountsCollection accounts;
    private final ReviewerResource.Factory resourceFactory;
    private final ListReviewers list;

    @Inject
    Reviewers(Provider<ReviewDb> dbProvider, ApprovalsUtil approvalsUtil, AccountsCollection accounts, ReviewerResource.Factory resourceFactory, DynamicMap<RestView<ReviewerResource>> views, ListReviewers list) {
        this.dbProvider = dbProvider;
        this.approvalsUtil = approvalsUtil;
        this.accounts = accounts;
        this.resourceFactory = resourceFactory;
        this.views = views;
        this.list = list;
    }

    @Override
    public DynamicMap<RestView<ReviewerResource>> views() {
        return this.views;
    }

    @Override
    public RestView<ChangeResource> list() {
        return this.list;
    }

    @Override
    public ReviewerResource parse(ChangeResource rsrc, IdString id) throws OrmException, ResourceNotFoundException, AuthException {
        Account.Id accountId = this.accounts.parse(TopLevelResource.INSTANCE, id).getUser().getAccountId();
        if (this.fetchAccountIds(rsrc).contains(accountId)) {
            return this.resourceFactory.create(rsrc, accountId);
        }
        throw new ResourceNotFoundException(id);
    }

    private Collection<Account.Id> fetchAccountIds(ChangeResource rsrc) throws OrmException {
        return this.approvalsUtil.getReviewers(this.dbProvider.get(), rsrc.getNotes()).all();
    }
}

