/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.base.MoreObjects;
import com.google.gerrit.common.data.SubmitTypeRecord;
import com.google.gerrit.extensions.client.SubmitType;
import com.google.gerrit.extensions.common.TestSubmitRuleInput;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.rules.RulesCache;
import com.google.gerrit.server.change.RevisionResource;
import com.google.gerrit.server.project.SubmitRuleEvaluator;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import org.kohsuke.args4j.Option;

public class TestSubmitType
implements RestModifyView<RevisionResource, TestSubmitRuleInput> {
    private final Provider<ReviewDb> db;
    private final ChangeData.Factory changeDataFactory;
    private final RulesCache rules;
    @Option(name="--filters", usage="impact of filters in parent projects")
    private TestSubmitRuleInput.Filters filters = TestSubmitRuleInput.Filters.RUN;

    @Inject
    TestSubmitType(Provider<ReviewDb> db, ChangeData.Factory changeDataFactory, RulesCache rules) {
        this.db = db;
        this.changeDataFactory = changeDataFactory;
        this.rules = rules;
    }

    public SubmitType apply(RevisionResource rsrc, TestSubmitRuleInput input) throws AuthException, BadRequestException, OrmException {
        if (input == null) {
            input = new TestSubmitRuleInput();
        }
        if (input.rule != null && !this.rules.isProjectRulesEnabled()) {
            throw new AuthException("project rules are disabled");
        }
        input.filters = MoreObjects.firstNonNull(input.filters, this.filters);
        SubmitRuleEvaluator evaluator = new SubmitRuleEvaluator(this.changeDataFactory.create(this.db.get(), rsrc.getControl()));
        SubmitTypeRecord rec = evaluator.setPatchSet(rsrc.getPatchSet()).setLogErrors(false).setSkipSubmitFilters(input.filters == TestSubmitRuleInput.Filters.SKIP).setRule(input.rule).getSubmitType();
        if (rec.status != SubmitTypeRecord.Status.OK) {
            throw new BadRequestException(String.format("rule %s produced invalid result: %s", evaluator.getSubmitRuleName(), rec));
        }
        return rec.type;
    }

    public static class Get
    implements RestReadView<RevisionResource> {
        private final TestSubmitType test;

        @Inject
        Get(TestSubmitType test) {
            this.test = test;
        }

        public SubmitType apply(RevisionResource resource) throws AuthException, BadRequestException, OrmException {
            return this.test.apply(resource, null);
        }
    }
}

