/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.config;

import com.google.gerrit.server.config.AllUsersName;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import org.eclipse.jgit.lib.Config;

@Singleton
public class AllUsersNameProvider
implements Provider<AllUsersName> {
    public static final String DEFAULT = "All-Users";
    private final AllUsersName name;

    @Inject
    AllUsersNameProvider(@GerritServerConfig Config cfg) {
        String n = cfg.getString("gerrit", null, "allUsers");
        if (n == null || n.isEmpty()) {
            n = DEFAULT;
        }
        this.name = new AllUsersName(n);
    }

    @Override
    public AllUsersName get() {
        return this.name;
    }
}

