/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.config;

import com.google.common.cache.Cache;
import com.google.gerrit.audit.AuditModule;
import com.google.gerrit.common.EventListener;
import com.google.gerrit.common.UserScopedEventListener;
import com.google.gerrit.extensions.annotations.Exports;
import com.google.gerrit.extensions.api.changes.ActionVisitor;
import com.google.gerrit.extensions.api.projects.CommentLinkInfo;
import com.google.gerrit.extensions.auth.oauth.OAuthLoginProvider;
import com.google.gerrit.extensions.auth.oauth.OAuthTokenEncrypter;
import com.google.gerrit.extensions.config.CapabilityDefinition;
import com.google.gerrit.extensions.config.CloneCommand;
import com.google.gerrit.extensions.config.DownloadCommand;
import com.google.gerrit.extensions.config.DownloadScheme;
import com.google.gerrit.extensions.config.ExternalIncludedIn;
import com.google.gerrit.extensions.config.FactoryModule;
import com.google.gerrit.extensions.events.AccountIndexedListener;
import com.google.gerrit.extensions.events.AgreementSignupListener;
import com.google.gerrit.extensions.events.AssigneeChangedListener;
import com.google.gerrit.extensions.events.ChangeAbandonedListener;
import com.google.gerrit.extensions.events.ChangeDeletedListener;
import com.google.gerrit.extensions.events.ChangeIndexedListener;
import com.google.gerrit.extensions.events.ChangeMergedListener;
import com.google.gerrit.extensions.events.ChangeRestoredListener;
import com.google.gerrit.extensions.events.ChangeRevertedListener;
import com.google.gerrit.extensions.events.CommentAddedListener;
import com.google.gerrit.extensions.events.DraftPublishedListener;
import com.google.gerrit.extensions.events.GarbageCollectorListener;
import com.google.gerrit.extensions.events.GitReferenceUpdatedListener;
import com.google.gerrit.extensions.events.GroupIndexedListener;
import com.google.gerrit.extensions.events.HashtagsEditedListener;
import com.google.gerrit.extensions.events.HeadUpdatedListener;
import com.google.gerrit.extensions.events.LifecycleListener;
import com.google.gerrit.extensions.events.NewProjectCreatedListener;
import com.google.gerrit.extensions.events.PluginEventListener;
import com.google.gerrit.extensions.events.ProjectDeletedListener;
import com.google.gerrit.extensions.events.ReviewerAddedListener;
import com.google.gerrit.extensions.events.ReviewerDeletedListener;
import com.google.gerrit.extensions.events.RevisionCreatedListener;
import com.google.gerrit.extensions.events.TopicEditedListener;
import com.google.gerrit.extensions.events.UsageDataPublishedListener;
import com.google.gerrit.extensions.events.VoteDeletedListener;
import com.google.gerrit.extensions.registration.DynamicItem;
import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.extensions.systemstatus.MessageOfTheDay;
import com.google.gerrit.extensions.webui.BranchWebLink;
import com.google.gerrit.extensions.webui.DiffWebLink;
import com.google.gerrit.extensions.webui.FileHistoryWebLink;
import com.google.gerrit.extensions.webui.FileWebLink;
import com.google.gerrit.extensions.webui.ParentWebLink;
import com.google.gerrit.extensions.webui.PatchSetWebLink;
import com.google.gerrit.extensions.webui.ProjectWebLink;
import com.google.gerrit.extensions.webui.TagWebLink;
import com.google.gerrit.extensions.webui.TopMenu;
import com.google.gerrit.extensions.webui.WebUiPlugin;
import com.google.gerrit.rules.PrologModule;
import com.google.gerrit.rules.RulesCache;
import com.google.gerrit.server.AnonymousUser;
import com.google.gerrit.server.ApprovalsUtil;
import com.google.gerrit.server.CmdLineParserModule;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.PluginUser;
import com.google.gerrit.server.Sequences;
import com.google.gerrit.server.account.AccountByEmailCacheImpl;
import com.google.gerrit.server.account.AccountCacheImpl;
import com.google.gerrit.server.account.AccountControl;
import com.google.gerrit.server.account.AccountManager;
import com.google.gerrit.server.account.AccountResolver;
import com.google.gerrit.server.account.AccountVisibility;
import com.google.gerrit.server.account.AccountVisibilityProvider;
import com.google.gerrit.server.account.CapabilityCollection;
import com.google.gerrit.server.account.CapabilityControl;
import com.google.gerrit.server.account.ChangeUserName;
import com.google.gerrit.server.account.EmailExpander;
import com.google.gerrit.server.account.GroupCacheImpl;
import com.google.gerrit.server.account.GroupControl;
import com.google.gerrit.server.account.GroupDetailFactory;
import com.google.gerrit.server.account.GroupIncludeCacheImpl;
import com.google.gerrit.server.account.GroupMembers;
import com.google.gerrit.server.account.VersionedAuthorizedKeys;
import com.google.gerrit.server.api.accounts.AccountExternalIdCreator;
import com.google.gerrit.server.auth.AuthBackend;
import com.google.gerrit.server.auth.UniversalAuthBackend;
import com.google.gerrit.server.auth.oauth.OAuthTokenCache;
import com.google.gerrit.server.avatar.AvatarProvider;
import com.google.gerrit.server.cache.CacheRemovalListener;
import com.google.gerrit.server.change.AccountPatchReviewStore;
import com.google.gerrit.server.change.ChangeJson;
import com.google.gerrit.server.change.ChangeKindCacheImpl;
import com.google.gerrit.server.change.MergeabilityCacheImpl;
import com.google.gerrit.server.change.ReviewerSuggestion;
import com.google.gerrit.server.config.AuthModule;
import com.google.gerrit.server.config.ChangeCleanupConfig;
import com.google.gerrit.server.config.DisableReverseDnsLookup;
import com.google.gerrit.server.config.DisableReverseDnsLookupProvider;
import com.google.gerrit.server.config.EmailExpanderProvider;
import com.google.gerrit.server.config.GcConfig;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.config.GitwebConfig;
import com.google.gerrit.server.config.Module;
import com.google.gerrit.server.config.PluginConfigFactory;
import com.google.gerrit.server.config.ProjectConfigEntry;
import com.google.gerrit.server.config.ProjectOwnerGroupsProvider;
import com.google.gerrit.server.events.EventFactory;
import com.google.gerrit.server.events.EventsMetrics;
import com.google.gerrit.server.extensions.events.GitReferenceUpdated;
import com.google.gerrit.server.git.AbandonOp;
import com.google.gerrit.server.git.ChangeMessageModifier;
import com.google.gerrit.server.git.EmailMerge;
import com.google.gerrit.server.git.GitModule;
import com.google.gerrit.server.git.GitModules;
import com.google.gerrit.server.git.MergeUtil;
import com.google.gerrit.server.git.MergedByPushOp;
import com.google.gerrit.server.git.NotesBranchUtil;
import com.google.gerrit.server.git.ReceivePackInitializer;
import com.google.gerrit.server.git.ReplaceOp;
import com.google.gerrit.server.git.SubmoduleOp;
import com.google.gerrit.server.git.TagCache;
import com.google.gerrit.server.git.TransferConfig;
import com.google.gerrit.server.git.strategy.SubmitStrategy;
import com.google.gerrit.server.git.validators.CommitValidationListener;
import com.google.gerrit.server.git.validators.MergeValidationListener;
import com.google.gerrit.server.git.validators.MergeValidators;
import com.google.gerrit.server.git.validators.OnSubmitValidationListener;
import com.google.gerrit.server.git.validators.OnSubmitValidators;
import com.google.gerrit.server.git.validators.RefOperationValidationListener;
import com.google.gerrit.server.git.validators.RefOperationValidators;
import com.google.gerrit.server.git.validators.UploadValidationListener;
import com.google.gerrit.server.git.validators.UploadValidators;
import com.google.gerrit.server.group.GroupModule;
import com.google.gerrit.server.index.change.ReindexAfterUpdate;
import com.google.gerrit.server.mail.EmailModule;
import com.google.gerrit.server.mail.ListMailFilter;
import com.google.gerrit.server.mail.MailFilter;
import com.google.gerrit.server.mail.send.AddKeySender;
import com.google.gerrit.server.mail.send.AddReviewerSender;
import com.google.gerrit.server.mail.send.CreateChangeSender;
import com.google.gerrit.server.mail.send.DeleteReviewerSender;
import com.google.gerrit.server.mail.send.FromAddressGenerator;
import com.google.gerrit.server.mail.send.FromAddressGeneratorProvider;
import com.google.gerrit.server.mail.send.MailSoyTofuProvider;
import com.google.gerrit.server.mail.send.MailTemplates;
import com.google.gerrit.server.mail.send.MergedSender;
import com.google.gerrit.server.mail.send.RegisterNewEmailSender;
import com.google.gerrit.server.mail.send.ReplacePatchSetSender;
import com.google.gerrit.server.mail.send.SetAssigneeSender;
import com.google.gerrit.server.mail.send.VelocityRuntimeProvider;
import com.google.gerrit.server.mime.FileTypeRegistry;
import com.google.gerrit.server.mime.MimeUtilFileTypeRegistry;
import com.google.gerrit.server.notedb.NoteDbModule;
import com.google.gerrit.server.patch.PatchListCacheImpl;
import com.google.gerrit.server.patch.PatchScriptFactory;
import com.google.gerrit.server.patch.PatchSetInfoFactory;
import com.google.gerrit.server.plugins.ReloadPluginListener;
import com.google.gerrit.server.project.AccessControlModule;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gerrit.server.project.CommentLinkProvider;
import com.google.gerrit.server.project.PermissionCollection;
import com.google.gerrit.server.project.ProjectCacheImpl;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.server.project.ProjectNode;
import com.google.gerrit.server.project.ProjectState;
import com.google.gerrit.server.project.SectionSortCache;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.ChangeQueryBuilder;
import com.google.gerrit.server.query.change.ConflictsCacheImpl;
import com.google.gerrit.server.ssh.SshAddressesModule;
import com.google.gerrit.server.tools.ToolsCatalog;
import com.google.gerrit.server.update.BatchUpdate;
import com.google.gerrit.server.util.IdGenerator;
import com.google.gerrit.server.util.ThreadLocalRequestContext;
import com.google.gerrit.server.validators.AssigneeValidationListener;
import com.google.gerrit.server.validators.GroupCreationValidationListener;
import com.google.gerrit.server.validators.HashtagValidationListener;
import com.google.gerrit.server.validators.OutgoingEmailValidationListener;
import com.google.gerrit.server.validators.ProjectCreationValidationListener;
import com.google.gitiles.blame.BlameCache;
import com.google.gitiles.blame.BlameCacheImpl;
import com.google.inject.Inject;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.internal.UniqueAnnotations;
import com.google.template.soy.tofu.SoyTofu;
import java.util.List;
import org.apache.velocity.runtime.RuntimeInstance;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.transport.PostReceiveHook;
import org.eclipse.jgit.transport.PostUploadHook;
import org.eclipse.jgit.transport.PreUploadHook;

public class GerritGlobalModule
extends FactoryModule {
    private final Config cfg;
    private final AuthModule authModule;

    @Inject
    GerritGlobalModule(@GerritServerConfig Config cfg, AuthModule authModule) {
        this.cfg = cfg;
        this.authModule = authModule;
    }

    @Override
    protected void configure() {
        this.bind(EmailExpander.class).toProvider(EmailExpanderProvider.class).in(Scopes.SINGLETON);
        this.bind(IdGenerator.class);
        this.bind(RulesCache.class);
        this.bind(BlameCache.class).to(BlameCacheImpl.class);
        this.bind(Sequences.class);
        this.install(this.authModule);
        this.install(AccountByEmailCacheImpl.module());
        this.install(AccountCacheImpl.module(true));
        this.install(BatchUpdate.module());
        this.install(ChangeKindCacheImpl.module());
        this.install(ConflictsCacheImpl.module());
        this.install(GroupCacheImpl.module());
        this.install(GroupIncludeCacheImpl.module());
        this.install(MergeabilityCacheImpl.module());
        this.install(PatchListCacheImpl.module());
        this.install(ProjectCacheImpl.module());
        this.install(SectionSortCache.module());
        this.install(SubmitStrategy.module());
        this.install(TagCache.module());
        this.install(OAuthTokenCache.module());
        this.install(new AccessControlModule());
        this.install(new CmdLineParserModule());
        this.install(new EmailModule());
        this.install(new GitModule());
        this.install(new GroupModule());
        this.install(new NoteDbModule(this.cfg));
        this.install(new PrologModule());
        this.install(new SshAddressesModule());
        this.install(ThreadLocalRequestContext.module());
        this.bind(AccountResolver.class);
        this.factory(AddReviewerSender.Factory.class);
        this.factory(DeleteReviewerSender.Factory.class);
        this.factory(AddKeySender.Factory.class);
        this.factory(CapabilityCollection.Factory.class);
        this.factory(CapabilityControl.Factory.class);
        this.factory(ChangeData.Factory.class);
        this.factory(ChangeJson.AssistedFactory.class);
        this.factory(CreateChangeSender.Factory.class);
        this.factory(GroupDetailFactory.Factory.class);
        this.factory(GroupMembers.Factory.class);
        this.factory(EmailMerge.Factory.class);
        this.factory(MergedSender.Factory.class);
        this.factory(MergeUtil.Factory.class);
        this.factory(PatchScriptFactory.Factory.class);
        this.factory(PluginUser.Factory.class);
        this.factory(ProjectNode.Factory.class);
        this.factory(ProjectState.Factory.class);
        this.factory(RegisterNewEmailSender.Factory.class);
        this.factory(ReplacePatchSetSender.Factory.class);
        this.factory(SetAssigneeSender.Factory.class);
        this.bind(PermissionCollection.Factory.class);
        this.bind(AccountVisibility.class).toProvider(AccountVisibilityProvider.class).in(Scopes.SINGLETON);
        this.factory(ProjectOwnerGroupsProvider.Factory.class);
        this.bind(AuthBackend.class).to(UniversalAuthBackend.class).in(Scopes.SINGLETON);
        DynamicSet.setOf(this.binder(), AuthBackend.class);
        this.bind(GroupControl.Factory.class).in(Scopes.SINGLETON);
        this.bind(GroupControl.GenericFactory.class).in(Scopes.SINGLETON);
        this.bind(FileTypeRegistry.class).to(MimeUtilFileTypeRegistry.class);
        this.bind(ToolsCatalog.class);
        this.bind(EventFactory.class);
        this.bind(TransferConfig.class);
        this.bind(GcConfig.class);
        this.bind(ChangeCleanupConfig.class);
        this.bind(ApprovalsUtil.class);
        this.bind(RuntimeInstance.class).toProvider(VelocityRuntimeProvider.class);
        this.bind(SoyTofu.class).annotatedWith(MailTemplates.class).toProvider(MailSoyTofuProvider.class);
        this.bind(FromAddressGenerator.class).toProvider(FromAddressGeneratorProvider.class).in(Scopes.SINGLETON);
        this.bind(Boolean.class).annotatedWith(DisableReverseDnsLookup.class).toProvider(DisableReverseDnsLookupProvider.class).in(Scopes.SINGLETON);
        this.bind(PatchSetInfoFactory.class);
        this.bind(IdentifiedUser.GenericFactory.class).in(Scopes.SINGLETON);
        this.bind(ChangeControl.GenericFactory.class);
        this.bind(ProjectControl.GenericFactory.class);
        this.bind(AccountControl.Factory.class);
        this.install(new AuditModule());
        this.install(new com.google.gerrit.server.access.Module());
        this.install(new com.google.gerrit.server.account.Module());
        this.install(new com.google.gerrit.server.api.Module());
        this.install(new com.google.gerrit.server.change.Module());
        this.install(new Module());
        this.install(new com.google.gerrit.server.group.Module());
        this.install(new com.google.gerrit.server.project.Module());
        this.bind(GitReferenceUpdated.class);
        DynamicMap.mapOf(this.binder(), new TypeLiteral<Cache<?, ?>>(){});
        DynamicSet.setOf(this.binder(), CacheRemovalListener.class);
        DynamicMap.mapOf(this.binder(), CapabilityDefinition.class);
        DynamicSet.setOf(this.binder(), GitReferenceUpdatedListener.class);
        DynamicSet.setOf(this.binder(), AssigneeChangedListener.class);
        DynamicSet.setOf(this.binder(), ChangeAbandonedListener.class);
        DynamicSet.setOf(this.binder(), ChangeDeletedListener.class);
        DynamicSet.setOf(this.binder(), CommentAddedListener.class);
        DynamicSet.setOf(this.binder(), DraftPublishedListener.class);
        DynamicSet.setOf(this.binder(), HashtagsEditedListener.class);
        DynamicSet.setOf(this.binder(), ChangeMergedListener.class);
        DynamicSet.setOf(this.binder(), ChangeRestoredListener.class);
        DynamicSet.setOf(this.binder(), ChangeRevertedListener.class);
        DynamicSet.setOf(this.binder(), ReviewerAddedListener.class);
        DynamicSet.setOf(this.binder(), ReviewerDeletedListener.class);
        DynamicSet.setOf(this.binder(), VoteDeletedListener.class);
        DynamicSet.setOf(this.binder(), RevisionCreatedListener.class);
        DynamicSet.setOf(this.binder(), TopicEditedListener.class);
        DynamicSet.setOf(this.binder(), AgreementSignupListener.class);
        DynamicSet.setOf(this.binder(), PluginEventListener.class);
        DynamicSet.setOf(this.binder(), ReceivePackInitializer.class);
        DynamicSet.setOf(this.binder(), PostReceiveHook.class);
        DynamicSet.setOf(this.binder(), PreUploadHook.class);
        DynamicSet.setOf(this.binder(), PostUploadHook.class);
        DynamicSet.setOf(this.binder(), AccountIndexedListener.class);
        DynamicSet.setOf(this.binder(), ChangeIndexedListener.class);
        DynamicSet.setOf(this.binder(), GroupIndexedListener.class);
        DynamicSet.setOf(this.binder(), NewProjectCreatedListener.class);
        DynamicSet.setOf(this.binder(), ProjectDeletedListener.class);
        DynamicSet.setOf(this.binder(), GarbageCollectorListener.class);
        DynamicSet.setOf(this.binder(), HeadUpdatedListener.class);
        DynamicSet.setOf(this.binder(), UsageDataPublishedListener.class);
        DynamicSet.bind(this.binder(), GitReferenceUpdatedListener.class).to(ReindexAfterUpdate.class);
        DynamicSet.bind(this.binder(), GitReferenceUpdatedListener.class).to(ProjectConfigEntry.UpdateChecker.class);
        DynamicSet.setOf(this.binder(), EventListener.class);
        DynamicSet.bind(this.binder(), EventListener.class).to(EventsMetrics.class);
        DynamicSet.setOf(this.binder(), UserScopedEventListener.class);
        DynamicSet.setOf(this.binder(), CommitValidationListener.class);
        DynamicSet.setOf(this.binder(), ChangeMessageModifier.class);
        DynamicSet.setOf(this.binder(), RefOperationValidationListener.class);
        DynamicSet.setOf(this.binder(), OnSubmitValidationListener.class);
        DynamicSet.setOf(this.binder(), MergeValidationListener.class);
        DynamicSet.setOf(this.binder(), ProjectCreationValidationListener.class);
        DynamicSet.setOf(this.binder(), GroupCreationValidationListener.class);
        DynamicSet.setOf(this.binder(), HashtagValidationListener.class);
        DynamicSet.setOf(this.binder(), OutgoingEmailValidationListener.class);
        DynamicItem.itemOf(this.binder(), AvatarProvider.class);
        DynamicSet.setOf(this.binder(), LifecycleListener.class);
        DynamicSet.setOf(this.binder(), TopMenu.class);
        DynamicSet.setOf(this.binder(), MessageOfTheDay.class);
        DynamicMap.mapOf(this.binder(), DownloadScheme.class);
        DynamicMap.mapOf(this.binder(), DownloadCommand.class);
        DynamicMap.mapOf(this.binder(), CloneCommand.class);
        DynamicMap.mapOf(this.binder(), ReviewerSuggestion.class);
        DynamicSet.setOf(this.binder(), ExternalIncludedIn.class);
        DynamicMap.mapOf(this.binder(), ProjectConfigEntry.class);
        DynamicSet.setOf(this.binder(), PatchSetWebLink.class);
        DynamicSet.setOf(this.binder(), ParentWebLink.class);
        DynamicSet.setOf(this.binder(), FileWebLink.class);
        DynamicSet.setOf(this.binder(), FileHistoryWebLink.class);
        DynamicSet.setOf(this.binder(), DiffWebLink.class);
        DynamicSet.setOf(this.binder(), ProjectWebLink.class);
        DynamicSet.setOf(this.binder(), BranchWebLink.class);
        DynamicSet.setOf(this.binder(), TagWebLink.class);
        DynamicMap.mapOf(this.binder(), OAuthLoginProvider.class);
        DynamicItem.itemOf(this.binder(), OAuthTokenEncrypter.class);
        DynamicSet.setOf(this.binder(), AccountExternalIdCreator.class);
        DynamicSet.setOf(this.binder(), WebUiPlugin.class);
        DynamicItem.itemOf(this.binder(), AccountPatchReviewStore.class);
        DynamicSet.setOf(this.binder(), AssigneeValidationListener.class);
        DynamicSet.setOf(this.binder(), ActionVisitor.class);
        DynamicMap.mapOf(this.binder(), MailFilter.class);
        this.bind(MailFilter.class).annotatedWith(Exports.named("ListMailFilter")).to(ListMailFilter.class);
        this.factory(UploadValidators.Factory.class);
        DynamicSet.setOf(this.binder(), UploadValidationListener.class);
        DynamicMap.mapOf(this.binder(), ChangeQueryBuilder.ChangeOperatorFactory.class);
        DynamicMap.mapOf(this.binder(), ChangeQueryBuilder.ChangeHasOperandFactory.class);
        this.install(new GitwebConfig.LegacyModule(this.cfg));
        this.bind(AnonymousUser.class);
        this.factory(AbandonOp.Factory.class);
        this.factory(RefOperationValidators.Factory.class);
        this.factory(OnSubmitValidators.Factory.class);
        this.factory(MergeValidators.Factory.class);
        this.factory(MergeValidators.ProjectConfigValidator.Factory.class);
        this.factory(NotesBranchUtil.Factory.class);
        this.factory(ReplaceOp.Factory.class);
        this.factory(MergedByPushOp.Factory.class);
        this.factory(GitModules.Factory.class);
        this.factory(VersionedAuthorizedKeys.Factory.class);
        this.factory(SubmoduleOp.Factory.class);
        this.bind(AccountManager.class);
        this.factory(ChangeUserName.Factory.class);
        this.bind(new TypeLiteral<List<CommentLinkInfo>>(){}).toProvider(CommentLinkProvider.class).in(Scopes.SINGLETON);
        this.bind(ReloadPluginListener.class).annotatedWith(UniqueAnnotations.create()).to(PluginConfigFactory.class);
    }
}

