/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.extensions.events;

import com.google.gerrit.extensions.events.PluginEventListener;
import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.server.extensions.events.AbstractNoNotifyEvent;
import com.google.inject.Inject;
import com.google.inject.Singleton;

@Singleton
public class PluginEvent {
    private final DynamicSet<PluginEventListener> listeners;

    @Inject
    PluginEvent(DynamicSet<PluginEventListener> listeners) {
        this.listeners = listeners;
    }

    public void fire(String pluginName, String type, String data) {
        if (!this.listeners.iterator().hasNext()) {
            return;
        }
        Event e = new Event(pluginName, type, data);
        for (PluginEventListener l : this.listeners) {
            l.onPluginEvent(e);
        }
    }

    private static class Event
    extends AbstractNoNotifyEvent
    implements PluginEventListener.Event {
        private final String pluginName;
        private final String type;
        private final String data;

        Event(String pluginName, String type, String data) {
            this.pluginName = pluginName;
            this.type = type;
            this.data = data;
        }

        @Override
        public String pluginName() {
            return this.pluginName;
        }

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        public String getData() {
            return this.data;
        }
    }
}

