/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git.strategy;

import com.google.gerrit.server.git.CodeReviewCommit;
import com.google.gerrit.server.git.IntegrationException;
import com.google.gerrit.server.git.strategy.CommitMergeStatus;
import com.google.gerrit.server.git.strategy.FastForwardOp;
import com.google.gerrit.server.git.strategy.SubmitDryRun;
import com.google.gerrit.server.git.strategy.SubmitStrategy;
import com.google.gerrit.server.git.strategy.SubmitStrategyOp;
import com.google.gerrit.server.update.RepoContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class FastForwardOnly
extends SubmitStrategy {
    FastForwardOnly(SubmitStrategy.Arguments args) {
        super(args);
    }

    @Override
    public List<SubmitStrategyOp> buildOps(Collection<CodeReviewCommit> toMerge) throws IntegrationException {
        List<CodeReviewCommit> sorted = this.args.mergeUtil.reduceToMinimalMerge(this.args.mergeSorter, toMerge, this.args.incoming);
        ArrayList<SubmitStrategyOp> ops = new ArrayList<SubmitStrategyOp>(sorted.size());
        CodeReviewCommit newTipCommit = this.args.mergeUtil.getFirstFastForward(this.args.mergeTip.getInitialTip(), this.args.rw, sorted);
        if (!newTipCommit.equals(this.args.mergeTip.getInitialTip())) {
            ops.add(new FastForwardOp(this.args, newTipCommit));
        }
        while (!sorted.isEmpty()) {
            ops.add(new NotFastForwardOp(sorted.remove(0)));
        }
        return ops;
    }

    static boolean dryRun(SubmitDryRun.Arguments args, CodeReviewCommit mergeTip, CodeReviewCommit toMerge) throws IntegrationException {
        return args.mergeUtil.canFastForward(args.mergeSorter, mergeTip, args.rw, toMerge);
    }

    private class NotFastForwardOp
    extends SubmitStrategyOp {
        private NotFastForwardOp(CodeReviewCommit toMerge) {
            super(FastForwardOnly.this.args, toMerge);
        }

        @Override
        public void updateRepoImpl(RepoContext ctx) {
            this.toMerge.setStatusCode(CommitMergeStatus.NOT_FAST_FORWARD);
        }
    }
}

