/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git.strategy;

import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableSet;
import com.google.gerrit.extensions.api.changes.SubmitInput;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.server.change.Submit;
import com.google.gerrit.server.git.CodeReviewCommit;
import com.google.gerrit.server.git.IntegrationException;
import com.google.gerrit.server.git.MergeOp;
import com.google.gerrit.server.git.strategy.CherryPick;
import com.google.gerrit.server.git.strategy.CommitMergeStatus;
import com.google.gerrit.server.git.strategy.SubmitStrategy;
import com.google.gerrit.server.update.BatchUpdateListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class SubmitStrategyListener
implements BatchUpdateListener {
    private final Collection<SubmitStrategy> strategies;
    private final MergeOp.CommitStatus commitStatus;
    private final boolean failAfterRefUpdates;

    public SubmitStrategyListener(SubmitInput input, Collection<SubmitStrategy> strategies, MergeOp.CommitStatus commitStatus) {
        this.strategies = strategies;
        this.commitStatus = commitStatus;
        this.failAfterRefUpdates = input instanceof Submit.TestSubmitInput ? ((Submit.TestSubmitInput)input).failAfterRefUpdates : false;
    }

    @Override
    public void afterUpdateRepos() throws ResourceConflictException {
        try {
            this.markCleanMerges();
            List<Change.Id> alreadyMerged = this.checkCommitStatus();
            this.findUnmergedChanges(alreadyMerged);
        }
        catch (IntegrationException e) {
            throw new ResourceConflictException(e.getMessage(), e);
        }
    }

    @Override
    public void afterUpdateRefs() throws ResourceConflictException {
        if (this.failAfterRefUpdates) {
            throw new ResourceConflictException("Failing after ref updates");
        }
    }

    private void findUnmergedChanges(List<Change.Id> alreadyMerged) throws ResourceConflictException, IntegrationException {
        for (SubmitStrategy strategy : this.strategies) {
            if (strategy instanceof CherryPick) continue;
            SubmitStrategy.Arguments args = strategy.args;
            Set<Change.Id> unmerged = args.mergeUtil.findUnmergedChanges(args.commitStatus.getChangeIds(args.destBranch), args.rw, args.canMergeFlag, args.mergeTip.getInitialTip(), args.mergeTip.getCurrentTip(), alreadyMerged);
            for (Change.Id id : unmerged) {
                this.commitStatus.problem(id, "internal error: change not reachable from new branch tip");
            }
        }
        this.commitStatus.maybeFailVerbose();
    }

    private void markCleanMerges() throws IntegrationException {
        for (SubmitStrategy strategy : this.strategies) {
            SubmitStrategy.Arguments args = strategy.args;
            CodeReviewCommit initialTip = args.mergeTip.getInitialTip();
            args.mergeUtil.markCleanMerges(args.rw, args.canMergeFlag, args.mergeTip.getCurrentTip(), initialTip == null ? ImmutableSet.of() : ImmutableSet.of(initialTip));
        }
    }

    private List<Change.Id> checkCommitStatus() throws ResourceConflictException {
        ArrayList<Change.Id> alreadyMerged = new ArrayList<Change.Id>(this.commitStatus.getChangeIds().size());
        block6: for (Change.Id id : this.commitStatus.getChangeIds()) {
            CommitMergeStatus s;
            CodeReviewCommit commit = this.commitStatus.get(id);
            CommitMergeStatus commitMergeStatus = s = commit != null ? commit.getStatusCode() : null;
            if (s == null) {
                this.commitStatus.problem(id, "internal error: change not processed by merge strategy");
                continue;
            }
            switch (s) {
                case CLEAN_MERGE: 
                case CLEAN_REBASE: 
                case CLEAN_PICK: 
                case SKIPPED_IDENTICAL_TREE: {
                    continue block6;
                }
                case ALREADY_MERGED: {
                    alreadyMerged.add(commit.getPatchsetId().getParentKey());
                    continue block6;
                }
                case PATH_CONFLICT: 
                case REBASE_MERGE_CONFLICT: 
                case MANUAL_RECURSIVE_MERGE: 
                case CANNOT_CHERRY_PICK_ROOT: 
                case CANNOT_REBASE_ROOT: 
                case NOT_FAST_FORWARD: {
                    this.commitStatus.problem(id, CharMatcher.is('\n').collapseFrom(s.getMessage(), ' '));
                    continue block6;
                }
                case MISSING_DEPENDENCY: {
                    this.commitStatus.problem(id, "depends on change that was not submitted");
                    continue block6;
                }
            }
            this.commitStatus.problem(id, "unspecified merge failure: " + (Object)((Object)s));
        }
        this.commitStatus.maybeFailVerbose();
        return alreadyMerged;
    }

    @Override
    public void afterUpdateChanges() throws ResourceConflictException {
        this.commitStatus.maybeFail("Error updating status");
    }
}

