/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git.validators;

import com.google.common.collect.ImmutableList;
import com.google.gerrit.extensions.api.projects.ProjectConfigEntryType;
import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.reviewdb.client.Branch;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.config.AllProjectsName;
import com.google.gerrit.server.config.PluginConfig;
import com.google.gerrit.server.config.ProjectConfigEntry;
import com.google.gerrit.server.git.CodeReviewCommit;
import com.google.gerrit.server.git.ProjectConfig;
import com.google.gerrit.server.git.validators.MergeValidationException;
import com.google.gerrit.server.git.validators.MergeValidationListener;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.project.ProjectState;
import com.google.inject.Inject;
import java.io.IOException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;

public class MergeValidators {
    private final DynamicSet<MergeValidationListener> mergeValidationListeners;
    private final ProjectConfigValidator.Factory projectConfigValidatorFactory;

    @Inject
    MergeValidators(DynamicSet<MergeValidationListener> mergeValidationListeners, ProjectConfigValidator.Factory projectConfigValidatorFactory) {
        this.mergeValidationListeners = mergeValidationListeners;
        this.projectConfigValidatorFactory = projectConfigValidatorFactory;
    }

    public void validatePreMerge(Repository repo, CodeReviewCommit commit, ProjectState destProject, Branch.NameKey destBranch, PatchSet.Id patchSetId, IdentifiedUser caller) throws MergeValidationException {
        ImmutableList<ProjectConfigValidator> validators = ImmutableList.of(new PluginMergeValidationListener(this.mergeValidationListeners), this.projectConfigValidatorFactory.create());
        for (MergeValidationListener mergeValidationListener : validators) {
            mergeValidationListener.onPreMerge(repo, commit, destProject, destBranch, patchSetId, caller);
        }
    }

    public static class PluginMergeValidationListener
    implements MergeValidationListener {
        private final DynamicSet<MergeValidationListener> mergeValidationListeners;

        public PluginMergeValidationListener(DynamicSet<MergeValidationListener> mergeValidationListeners) {
            this.mergeValidationListeners = mergeValidationListeners;
        }

        @Override
        public void onPreMerge(Repository repo, CodeReviewCommit commit, ProjectState destProject, Branch.NameKey destBranch, PatchSet.Id patchSetId, IdentifiedUser caller) throws MergeValidationException {
            for (MergeValidationListener validator : this.mergeValidationListeners) {
                validator.onPreMerge(repo, commit, destProject, destBranch, patchSetId, caller);
            }
        }
    }

    public static class ProjectConfigValidator
    implements MergeValidationListener {
        private static final String INVALID_CONFIG = "Change contains an invalid project configuration.";
        private static final String PARENT_NOT_FOUND = "Change contains an invalid project configuration:\nParent project does not exist.";
        private static final String PLUGIN_VALUE_NOT_EDITABLE = "Change contains an invalid project configuration:\nOne of the plugin configuration parameters is not editable.";
        private static final String PLUGIN_VALUE_NOT_PERMITTED = "Change contains an invalid project configuration:\nOne of the plugin configuration parameters has a value that is not permitted.";
        private static final String ROOT_NO_PARENT = "Change contains an invalid project configuration:\nThe root project cannot have a parent.";
        private static final String SET_BY_ADMIN = "Change contains a project configuration that changes the parent project.\nThe change must be submitted by a Gerrit administrator.";
        private final AllProjectsName allProjectsName;
        private final ProjectCache projectCache;
        private final DynamicMap<ProjectConfigEntry> pluginConfigEntries;

        @Inject
        public ProjectConfigValidator(AllProjectsName allProjectsName, ProjectCache projectCache, DynamicMap<ProjectConfigEntry> pluginConfigEntries) {
            this.allProjectsName = allProjectsName;
            this.projectCache = projectCache;
            this.pluginConfigEntries = pluginConfigEntries;
        }

        @Override
        public void onPreMerge(Repository repo, CodeReviewCommit commit, ProjectState destProject, Branch.NameKey destBranch, PatchSet.Id patchSetId, IdentifiedUser caller) throws MergeValidationException {
            if ("refs/meta/config".equals(destBranch.get())) {
                try {
                    ProjectConfig cfg = new ProjectConfig(destProject.getProject().getNameKey());
                    cfg.load(repo, (ObjectId)commit);
                    Project.NameKey newParent = cfg.getProject().getParent(this.allProjectsName);
                    Project.NameKey oldParent = destProject.getProject().getParent(this.allProjectsName);
                    if (oldParent == null) {
                        if (newParent != null) {
                            throw new MergeValidationException(ROOT_NO_PARENT);
                        }
                    } else if (!oldParent.equals(newParent)) {
                        if (!caller.getCapabilities().canAdministrateServer()) {
                            throw new MergeValidationException(SET_BY_ADMIN);
                        }
                        if (this.projectCache.get(newParent) == null) {
                            throw new MergeValidationException(PARENT_NOT_FOUND);
                        }
                    }
                    for (DynamicMap.Entry<ProjectConfigEntry> entry : this.pluginConfigEntries) {
                        PluginConfig pluginCfg = cfg.getPluginConfig(entry.getPluginName());
                        ProjectConfigEntry configEntry = entry.getProvider().get();
                        String value = pluginCfg.getString(entry.getExportName());
                        String oldValue = destProject.getConfig().getPluginConfig(entry.getPluginName()).getString(entry.getExportName());
                        if ((value == null ? oldValue != null : !value.equals(oldValue)) && !configEntry.isEditable(destProject)) {
                            throw new MergeValidationException(PLUGIN_VALUE_NOT_EDITABLE);
                        }
                        if (!ProjectConfigEntryType.LIST.equals((Object)configEntry.getType()) || value == null || configEntry.getPermittedValues().contains(value)) continue;
                        throw new MergeValidationException(PLUGIN_VALUE_NOT_PERMITTED);
                    }
                }
                catch (IOException | ConfigInvalidException e) {
                    throw new MergeValidationException(INVALID_CONFIG);
                }
            }
        }

        public static interface Factory {
            public ProjectConfigValidator create();
        }
    }

    public static interface Factory {
        public MergeValidators create();
    }
}

